package com.bxm.newidea.component.ueditor.upload;

import com.bxm.newidea.component.enums.FileTypeEnum;
import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.UUIDUtils;
import com.bxm.newidea.component.ueditor.define.AppInfo;
import com.bxm.newidea.component.ueditor.define.BaseState;
import com.bxm.newidea.component.ueditor.define.State;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.EncoderException;
import it.sauronsoftware.jave.MultimediaInfo;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.util.*;

public class BinaryUploader {

    private static Logger logger = LoggerFactory.getLogger(BinaryUploader.class);

    public static final State save(HttpServletRequest request,
                                   Map<String, Object> conf) {
        boolean isAjaxUpload = request.getHeader("X_Requested_With") != null;

        if (!ServletFileUpload.isMultipartContent(request)) {
            return new BaseState(false, AppInfo.NOT_MULTIPART_CONTENT);
        }

        ServletFileUpload upload = new ServletFileUpload(
                new DiskFileItemFactory());

        if (isAjaxUpload) {
            upload.setHeaderEncoding("UTF-8");
        }

        try {
            State storageState = null;
            CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
            // 检查form中是否有enctype="multipart/form-data"
            if (multipartResolver.isMultipart(request)) {
                // 将request变成多部分request
                MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
                // 获取multiRequest 中所有的文件名
                Iterator<String> it = multiRequest.getFileNames();
                // 遍历文件
                while (it.hasNext()) {
                    MultipartFile file = multiRequest.getFile(it.next());

                    if (file != null) {
                        // 取得当前上传文件的文件名称
                        String fileName = file.getOriginalFilename();
                        // 如果名称不为空,说明该文件存在，否则说明该文件不存在
                        if (fileName.trim() != "") {
                            File newFile = new File(fileName);
                            FileOutputStream outStream = new FileOutputStream(newFile); // 文件输出流用于将数据写入文件
                            outStream.write(file.getBytes());
                            outStream.close(); // 关闭文件输出流
                            file.transferTo(newFile);
                            // *******************上传到阿里云开始***********************
                            try {

                                storageState = new BaseState(Boolean.TRUE);
                                storageState.putInfo("state", "SUCCESS");// UEDITOR的规则:不为SUCCESS则显示state的内容

                                //随机生成文件名
                                String pathWithoutSuffix = UUIDUtils.nextID();
                                String path = pathWithoutSuffix
                                        + "." + FileUtils.getFileExtension(newFile);
                                String url = getService().upload(newFile, path);
                                if (isImage(newFile)) {
                                    url = url + "?x-oss-process=style/mcompress";
                                }

                                if (isVideo(newFile)) {
                                    cacheVideoInfo(url,newFile,pathWithoutSuffix);
                                }

                                storageState.putInfo("url", url);
                                storageState.putInfo("title", fileName);
                                storageState.putInfo("original", fileName);
                                newFile.delete();
                            } catch (Exception e) {
                                // TODO: handle exception
                                storageState.putInfo("state", "文件上传失败!");
                                storageState.putInfo("url", "");
                                storageState.putInfo("title", "");
                                storageState.putInfo("original", "");
                                e.printStackTrace();
                            }

                            // ********************上传到阿里云结束**********************
                        }
                    }
                }
            }

            return storageState;
            // } catch (FileUploadException e) {
            //  return new BaseState(false, AppInfo.PARSE_REQUEST_ERROR);
        } catch (IOException e) {
        }
        return new BaseState(false, AppInfo.IO_ERROR);
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);

        return list.contains(type);
    }

    /**
     * 获取阿里OSS实例
     * @return
     */
    private static AliyunOSSService getService() {
        return SpringContextHolder.getBean("aliyunOssService");
    }

    /**
     * 是否是图片类型
     * @param file
     * @return
     */
    private static Boolean isImage(File file) {
        String suffix = FileUtils.getFileExtension(file);
        return FileTypeEnum.JPE.getExtName().equals(suffix) ||
                FileTypeEnum.JPEG.getExtName().equals(suffix) ||
                FileTypeEnum.PNG.getExtName().equals(suffix);
    }

    /**
     * 是否是视频类型
     * @param file
     * @return
     */
    private static Boolean isVideo(File file) {
        String suffix = FileUtils.getFileExtension(file);
        return FileTypeEnum.AVI.getExtName().equals(suffix) ||
                FileTypeEnum.FLV.getExtName().equals(suffix) ||
                FileTypeEnum.MP4.getExtName().equals(suffix);
    }

    /**
     * 将视频信息缓存到redis中，在帖子或者新闻保存时，将根据文件名作为key去redis缓存中去查找视频信息
     * @param file
     * @param videoBaseName
     * @throws EncoderException
     * @throws IOException
     */
    private static void cacheVideoInfo(String videoUrl,File file,String videoBaseName) throws EncoderException, IOException {
        Encoder encoder = new Encoder();
        MultimediaInfo m = encoder.getInfo(file);
        long ls = m.getDuration();

        FileInputStream fis = new FileInputStream(file);
        FileChannel fc= fis.getChannel();
        BigDecimal fileSize = new BigDecimal(fc.size());

        String imgUrl = getImageFromCover(videoUrl,videoBaseName);

        Map<String,Object> videoCacheMap = new HashMap<>();
        videoCacheMap.put("duration",ls);
        videoCacheMap.put("size",fileSize);
        videoCacheMap.put("imgUrl",imgUrl);

        KeyGenerator videoCacheKey = DefaultKeyGenerator.build("cache", "static","videoinfo");
        logger.debug("将视频信息存入redis中，redisKey:{},subKey:{},info:{}",videoCacheKey,videoBaseName,videoCacheMap);
        RedisHashMapAdapter redisHashMapAdapter =SpringContextHolder.getBean(RedisHashMapAdapter.class);
        redisHashMapAdapter.put(videoCacheKey,videoBaseName,videoCacheMap);
    }

    /**
     * 根据视频地址获取封面图并上传至oss中，返回封面的地址
     * @param videoUrl
     * @param videoBaseName
     * @return
     */
    private static String getImageFromCover(String videoUrl,String videoBaseName) {
        try {
            String coverUlr = videoUrl+"?x-oss-process=video/snapshot,t_1000,m_fast";
            URL url = new URL(coverUlr);
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();

            // 设置连接超时时间
            conn.setConnectTimeout(3000);
            InputStream inputStream = null;

            // 正常响应时获取输入流, 在这里也就是图片对应的字节流
            if (conn.getResponseCode() == HttpStatus.OK.value()) {
                inputStream = conn.getInputStream();
                logger.debug("根据url获得图片的流状态：{}", inputStream.available());
            }

            String path = videoBaseName + ".jpeg";
            return getService().upload(inputStream, path) + "?x-oss-process=style/video";
        } catch (IOException e) {
            logger.error("根据图片流上传os过程发生错误:{}",e.getMessage());
        }
        return "";
    }
}
