/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.ueditor.upload;

import com.bxm.newidea.component.oss.service.AliyunOSSService;
import com.bxm.newidea.component.tools.FileUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.UUIDUtils;
import com.bxm.newidea.component.ueditor.define.BaseState;
import com.bxm.newidea.component.ueditor.define.State;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class BinaryUploader {
    public static final State save(HttpServletRequest request, Map<String, Object> conf) {
        boolean isAjaxUpload;
        boolean bl = isAjaxUpload = request.getHeader("X_Requested_With") != null;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return new BaseState(false, 5);
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        if (isAjaxUpload) {
            upload.setHeaderEncoding("UTF-8");
        }
        try {
            BaseState storageState = null;
            CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
            if (multipartResolver.isMultipart(request)) {
                MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest)request;
                Iterator it = multiRequest.getFileNames();
                while (it.hasNext()) {
                    String fileName;
                    MultipartFile file = multiRequest.getFile(((String)it.next()).toString());
                    if (file == null || (fileName = file.getOriginalFilename()).trim() == "") continue;
                    File newFile = new File(fileName);
                    FileOutputStream outStream = new FileOutputStream(newFile);
                    outStream.write(file.getBytes());
                    outStream.close();
                    file.transferTo(newFile);
                    try {
                        storageState = new BaseState(Boolean.TRUE);
                        storageState.putInfo("state", "SUCCESS");
                        storageState.putInfo("url", BinaryUploader.getService().upload(newFile, UUIDUtils.nextID() + "." + FileUtils.getFileExtension((File)newFile)));
                        storageState.putInfo("title", fileName);
                        storageState.putInfo("original", fileName);
                        newFile.delete();
                    }
                    catch (Exception e) {
                        storageState.putInfo("state", "\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25!");
                        storageState.putInfo("url", "");
                        storageState.putInfo("title", "");
                        storageState.putInfo("original", "");
                    }
                }
            }
            return storageState;
        }
        catch (IOException iOException) {
            return new BaseState(false, 4);
        }
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }

    private static AliyunOSSService getService() {
        return (AliyunOSSService)SpringContextHolder.getBean((String)"aliyunOssService");
    }
}

