package com.bxm.newidea.component.ueditor.controller;

import com.bxm.newidea.component.ueditor.ActionEnter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

/**
 * @author zhaoyadong 2019/1/11 16:32
 * @desc
 */
@RestController
@RequestMapping("/ueditor")
public class UeditorController {

    private static final Logger logger = LoggerFactory.getLogger(UeditorController.class);

//    @RequestMapping(value = "/config", produces = "application/json,charset=utf-8")
//    public @ResponseBody
//    String config(HttpServletRequest request, HttpServletResponse response) {
//        return new ActionEnter(request, getRootPath()).exec();
//    }

    @RequestMapping(value = "/config")
    public void config(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/javascript");
        try {
            String exec = new ActionEnter(request, getRootPath()).exec();
            PrintWriter writer = response.getWriter();
            writer.write(exec);
            writer.flush();
            writer.close();
        } catch (IOException e) {
            logger.error("ueditor配置读取失败, 错误信息：{}", e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * 获取jar包下的根路径
     * @return
     */
    private String getRootPath() {
        StringBuffer stringBuffer = new StringBuffer();
        InputStream inputStream = ClassUtils.class.getClassLoader().getResourceAsStream("config.properties");
        return stringBuffer.toString();
    }
}
