/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.uuid.impl;

import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.ComponentUUIDConfigurationProperties;
import com.bxm.newidea.component.uuid.impl.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.NumberUtils;

public class SnowflakeSequenceCreater
implements SequenceCreater {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeSequenceCreater.class);
    private Sequence sequence;

    public void init(ComponentUUIDConfigurationProperties properties) {
        String configDataCenterId;
        Long workerId = properties.getWorkerid();
        Long dataCenterId = properties.getDataCenterId();
        String configWorkerId = System.getProperty("uuid.workerid");
        if (null != configWorkerId) {
            log.debug("\u4f7f\u7528\u7cfb\u7edf\u914d\u7f6e\u7684[uuid.workerid]:[{}]", (Object)configWorkerId);
            workerId = (Long)NumberUtils.parseNumber((String)configWorkerId, Long.class);
        }
        if (null != (configDataCenterId = System.getProperty("uuid.dataCenterId"))) {
            log.debug("\u4f7f\u7528\u7cfb\u7edf\u914d\u7f6e\u7684[uuid.dataCenterId]:[{}]", (Object)configDataCenterId);
            dataCenterId = (Long)NumberUtils.parseNumber((String)configDataCenterId, Long.class);
        }
        if (workerId == null) {
            workerId = RandomUtils.nextLong((long)0L, (long)255L);
        }
        if (dataCenterId == null) {
            dataCenterId = RandomUtils.nextLong((long)0L, (long)31L);
        }
        log.info("\u5e8f\u5217\u521b\u5efa\u53c2\u6570,workerId:{},dataCenterId:{}", (Object)workerId, (Object)dataCenterId);
        this.sequence = new Sequence(workerId, dataCenterId);
    }

    @Override
    public Long nextLongId() {
        return this.sequence.nextId();
    }

    @Override
    public String nextStringId() {
        return this.sequence.nextId().toString();
    }
}

