package com.bxm.newidea.component.uuid.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * uuid模块的相关配置
 * @author liujia
 * @date 2020/04/23 09:35
 */
@Data
@ConfigurationProperties(prefix = "uuid")
public class ComponentUUIDConfigurationProperties {
    /**
     * 工作节点ID，数值范围0-255
     * 相同的数据中心ID，工作节点不可重复，不然会导致高并发情况下创建出相同的序列号
     */
    private Long workerid;

    /**
     * 数据中心ID，数值范围0-31
     */
    private Long dataCenterId;
}
