/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.uuid.config;

import com.bxm.newidea.component.strategy.ReturnedStrategyExecutor;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.ComponentUUIDConfigurationProperties;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import com.bxm.newidea.component.uuid.snowflake.SnowflakeSequenceCrater;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ComponentUUIDConfigurationProperties.class})
public class ComponentUUIDAutoConfiguration
implements ApplicationRunner {
    private ComponentUUIDConfigurationProperties properties;
    private ReturnedStrategyExecutor returnedStrategyExecutor;

    public ComponentUUIDAutoConfiguration(ComponentUUIDConfigurationProperties properties, ReturnedStrategyExecutor returnedStrategyExecutor) {
        this.properties = properties;
        this.returnedStrategyExecutor = returnedStrategyExecutor;
    }

    @Bean
    @ConditionalOnMissingBean(value={SequenceCreater.class})
    public SequenceCreater sequenceCreater() {
        return new SnowflakeSequenceCrater(this.properties, this.returnedStrategyExecutor);
    }

    public void run(ApplicationArguments args) {
        SequenceHolder.sequenceCreater = (SequenceCreater)SpringContextHolder.getBean(SequenceCreater.class);
    }
}

