/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.uuid.snowflake;

import cn.hutool.core.date.SystemClock;
import java.security.SecureRandom;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sequence {
    private static final Logger log = LoggerFactory.getLogger(Sequence.class);
    private final long startTime = 1519740777809L;
    private final long workerIdBits = 12L;
    private final long sequenceBits = 12L;
    private final long maxWorkerId;
    private final long workerIdShift;
    private final long timestampLeftShift;
    private final long sequenceMask;
    private long workerId;
    private long dataCenterId;
    private long sequence;
    private long lastTimestamp;
    private boolean isClock;
    private static final Random RANDOM = new SecureRandom();

    public Sequence(long workerId, long dataCenterId) {
        this.getClass();
        this.maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << 12;
        this.getClass();
        this.workerIdShift = 12L;
        this.getClass();
        this.getClass();
        this.timestampLeftShift = 12L + 12L + 1L;
        this.getClass();
        this.sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << 12;
        this.sequence = 0L;
        this.lastTimestamp = -1L;
        this.isClock = true;
        if (workerId > this.maxWorkerId || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", this.maxWorkerId));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public void setClock(boolean clock) {
        this.isClock = clock;
    }

    public synchronized Long nextId() {
        long timestamp;
        block9: {
            timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                long offset = this.lastTimestamp - timestamp;
                if (offset <= 5L) {
                    try {
                        this.wait(offset << 1);
                        timestamp = this.timeGen();
                        if (timestamp < this.lastTimestamp) {
                            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
                        }
                        break block9;
                    }
                    catch (InterruptedException e) {
                        log.error(e.getMessage(), (Throwable)e);
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
            }
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = timestamp % 128L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.startTime << (int)this.timestampLeftShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return SystemClock.now();
    }
}

