package com.bxm.newidea.component.uuid;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.NumberUtils;

import javax.annotation.PostConstruct;

/**
 * 序列创建工具，用于创建有序的序列（根据时间大致有序）
 * @author liujia
 */
@Component
public class SequenceCreater {

    private static Logger LOGGER = LoggerFactory.getLogger(SequenceCreater.class);

    private long workerId = 0;

    private long dataCenterId = 2;

    private Sequence sequence;

    @PostConstruct
    private void init() {
        String configWorkerId = System.getProperty("uuid.workerid");
        if (null != configWorkerId) {
            LOGGER.info("使用系统配置的[uuid.workerid]:[{}]", configWorkerId);
            this.workerId = NumberUtils.parseNumber(configWorkerId, Long.class);
        }

        String configDataCenterId = System.getProperty("uuid.dataCenterId");
        if (null != configDataCenterId) {
            LOGGER.info("使用系统配置的[uuid.dataCenterId]:[{}]", configDataCenterId);
            this.dataCenterId = NumberUtils.parseNumber(configDataCenterId, Long.class);
        }
        this.sequence = new Sequence(this.workerId, this.dataCenterId);
    }

    public Long nextLongId() {
        return this.sequence.nextId();
    }

    public String nextStringId() {
        return this.sequence.nextId().toString();
    }
}
