/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.uuid;

import com.bxm.newidea.component.uuid.Sequence;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.NumberUtils;

@Component
public class SequenceCreater {
    private static Logger LOGGER = LoggerFactory.getLogger(SequenceCreater.class);
    @Value(value="${component.uuid.workerid:0}")
    private long workerId;
    @Value(value="${component.uuid.dataCenterId:2}")
    private long dataCenterId;
    private Sequence sequence;

    @PostConstruct
    private void init() {
        String configDataCenterId;
        String configWorkerId = System.getProperty("uuid.workerid");
        if (null != configWorkerId) {
            LOGGER.info("\u4f7f\u7528\u7cfb\u7edf\u914d\u7f6e\u7684[uuid.workerid]:[{}]", (Object)configWorkerId);
            this.workerId = (Long)NumberUtils.parseNumber((String)configWorkerId, Long.class);
        }
        if (null != (configDataCenterId = System.getProperty("uuid.dataCenterId"))) {
            LOGGER.info("\u4f7f\u7528\u7cfb\u7edf\u914d\u7f6e\u7684[uuid.dataCenterId]:[{}]", (Object)configDataCenterId);
            this.dataCenterId = (Long)NumberUtils.parseNumber((String)configDataCenterId, Long.class);
        }
        this.sequence = new Sequence(this.workerId, this.dataCenterId);
    }

    public Long nextLongId() {
        return this.sequence.nextId();
    }

    public String nextStringId() {
        return this.sequence.nextId().toString();
    }
}

