package com.bxm.newidea.component.config;

import com.bxm.newidea.component.mvc.ApiVersionRequestMapping;
import org.hibernate.validator.HibernateValidator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.validation.annotation.Validated;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

/**
 * 公共的web配置
 *
 * @author liujia
 */
@Configuration
@AutoConfigureAfter(WebMvcAutoConfiguration.class)
@EnableConfigurationProperties(ComponentWebConfigurationProperties.class)
public class ComponentWebAutoConfiguration implements WebMvcRegistrations {

    private ComponentWebConfigurationProperties properties;

    public ComponentWebAutoConfiguration(ComponentWebConfigurationProperties properties) {
        this.properties = properties;
    }

    @Override
    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return new ApiVersionRequestMapping();
    }

    @Override
    public RequestMappingHandlerAdapter getRequestMappingHandlerAdapter() {
        RequestMappingHandlerAdapter adapter = new RequestMappingHandlerAdapter();

        List<HttpMessageConverter<?>> converters = adapter.getMessageConverters();

        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();

        List<MediaType> supportedMediaTypes = new ArrayList<>();
        supportedMediaTypes.add(new MediaType(MediaType.TEXT_PLAIN, Charset.forName("UTF-8")));
        supportedMediaTypes.add(new MediaType(MediaType.APPLICATION_JSON, Charset.forName("UTF-8")));

        jsonConverter.setSupportedMediaTypes(supportedMediaTypes);

        converters.add(jsonConverter);

        adapter.setMessageConverters(converters);

        return adapter;
    }

    /**
     * 自定义验证工具，覆盖默认的验证工具
     *
     * @return 自定义验证器
     */
    @Bean
    public Validator validator() {
        ValidatorFactory validatorFactory = Validation.byProvider(HibernateValidator.class)
                .configure()
                //启用快速失败，当验证条件有一个不符合时即返回错误
                .failFast(properties.isFastValid())
                .buildValidatorFactory();
        return validatorFactory.getValidator();
    }

    /**
     * 启用方法基本的验证，在Controller上增加{@link Validated}，支持直接对简单参数设定验证注解
     *
     * @return 方法验证后置处理器
     */
    @Bean
    public MethodValidationPostProcessor methodValidationPostProcessor() {
        //启用方法级的验证
        MethodValidationPostProcessor postProcessor = new MethodValidationPostProcessor();
        postProcessor.setValidator(validator());
        return postProcessor;
    }
}
