package com.bxm.newidea.component.binder;

import com.bxm.newidea.component.tools.DateUtils;
import org.springframework.util.StringUtils;

import java.beans.PropertyEditorSupport;
import java.util.Date;

/**
 * 日期类型的选项值转换
 * @author liujia 2018/4/22 15:07
 */
public class DateEditor extends PropertyEditorSupport {

    @Override
    public String getAsText() {
        Date value = (Date) this.getValue();
        return DateUtils.formatDateNonStrict(value);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (!StringUtils.hasText(text)) {
            // Treat empty String as null value.
            this.setValue(null);
        }

        this.setValue(DateUtils.parseDateNonStrict(text));
    }
}
