/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.log;

import com.bxm.newidea.component.config.ComponentWebConfigurationProperties;
import com.bxm.newidea.component.util.WebUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

@WebFilter(filterName="log4j2ContextFilter", urlPatterns={"/**"})
public class LogContextFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(LogContextFilter.class);
    private ComponentWebConfigurationProperties properties;
    private AntPathMatcher antPathMatcher;

    public LogContextFilter(ComponentWebConfigurationProperties properties) {
        this.properties = properties;
        this.antPathMatcher = new AntPathMatcher();
    }

    public void init(FilterConfig filterConfig) {
        if (log.isDebugEnabled()) {
            log.debug("init log context filter");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        Object request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (!WebUtils.isMultipartRequest(request) && !(request instanceof ContentCachingRequestWrapper)) {
            request = new ContentCachingRequestWrapper((HttpServletRequest)request);
        }
        if (this.properties.isEnableRequestLog()) {
            String url = request.getRequestURI();
            for (String logUrl : this.properties.getIncludeUrlList()) {
                if (!this.antPathMatcher.match(logUrl, url)) continue;
                String requestParam = WebUtils.getRequestParam(request);
                log.info("\u8bf7\u6c42\u5730\u5740\uff1a[{}]\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a[{}]", (Object)url, (Object)requestParam);
            }
        }
        ThreadContext.put((String)"requestIp", (String)WebUtils.getIpAddr(request));
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        ThreadContext.clearAll();
    }

    private class ContentCachingRequestWrapper
    extends HttpServletRequestWrapper {
        private byte[] body;
        private BufferedReader reader;
        private ServletInputStream inputStream;
        private Map<String, String[]> paramMap;

        private ContentCachingRequestWrapper(HttpServletRequest request) throws IOException {
            super(request);
            this.loadBody(request);
            this.paramMap = new HashMap<String, String[]>(request.getParameterMap());
        }

        private void loadBody(HttpServletRequest request) throws IOException {
            this.body = IOUtils.toByteArray((InputStream)request.getInputStream());
            this.inputStream = new RequestCachingInputStream(this.body);
        }

        public ServletInputStream getInputStream() throws IOException {
            return new RequestCachingInputStream(this.body);
        }

        public BufferedReader getReader() throws IOException {
            if (this.reader == null) {
                this.reader = new BufferedReader(new InputStreamReader((InputStream)this.inputStream, this.getCharacterEncoding()));
            }
            return this.reader;
        }

        public String getParameter(String name) {
            String[] strings = this.paramMap.get(name);
            if (null != strings && strings.length > 0) {
                return strings[0];
            }
            return null;
        }

        public Map<String, String[]> getParameterMap() {
            return this.paramMap;
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.paramMap.keySet());
        }

        public String[] getParameterValues(String name) {
            return this.paramMap.get(name);
        }

        private class RequestCachingInputStream
        extends ServletInputStream {
            private final ByteArrayInputStream inputStream;

            private RequestCachingInputStream(byte[] bytes) {
                this.inputStream = new ByteArrayInputStream(bytes);
            }

            public int read() {
                return this.inputStream.read();
            }

            public int read(byte[] b) throws IOException {
                return this.inputStream.read(b);
            }

            public boolean isFinished() {
                return this.inputStream.available() == 0;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readlistener) {
            }
        }
    }
}

