package com.bxm.newidea.component.config;

import com.bxm.newidea.component.log.LogContextFilter;
import com.bxm.newidea.component.mvc.ApiVersionRequestMapping;
import org.hibernate.validator.HibernateValidator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

/**
 * 公共的web配置
 *
 * @author liujia
 */
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties(ComponentWebConfigurationProperties.class)
public class ComponentWebAutoConfiguration implements WebMvcRegistrations {

    private ComponentWebConfigurationProperties properties;

    public ComponentWebAutoConfiguration(ComponentWebConfigurationProperties properties) {
        this.properties = properties;
    }

    @Override
    public RequestMappingHandlerMapping getRequestMappingHandlerMapping() {
        return new ApiVersionRequestMapping();
    }

    @Bean
    @ConditionalOnProperty(prefix = "component.web", value = "enableLogFilter", matchIfMissing = true)
    public LogContextFilter logContextFilter() {
        return new LogContextFilter(properties);
    }

    /**
     * 自定义验证工具，覆盖默认的验证工具
     *
     * @return 自定义验证器
     */
    @Bean
    @Primary
    public Validator validator() {
        ValidatorFactory validatorFactory = Validation.byProvider(HibernateValidator.class)
                                                      .configure()
                                                      //启用快速失败，当验证条件有一个不符合时即返回错误
                                                      .failFast(properties.isFastValid())
                                                      .buildValidatorFactory();
        return validatorFactory.getValidator();
    }
}
