package com.bxm.newidea.component.config;

import com.google.common.collect.Lists;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;

/**
 * 配置参数
 *
 * @author liujia
 * @date 2020/04/22 14:30
 */
@ConfigurationProperties(prefix = "component.web")
@Data
public class ComponentWebConfigurationProperties {

    /**
     * 是否启用快速验证
     * 如果为true则验证属性第一个错误的情况下就会直接返回
     */
    private boolean fastValid = false;

    /**
     * 是否启用过滤器
     */
    private boolean enableLogFilter = true;

    /**
     * 是否开启日志显示
     */
    private boolean enableRequestLog = false;

    /**
     * 响应内容是否转化lang类型
     */
    private boolean jsonConvertLangType = false;

    /**
     * 使用统一对象映射器
     */
    private boolean useUnifiedObjectMapper = true;

    /**
     * 需要显示日志的路径列表
     */
    private List<String> includeUrlList = Lists.newArrayList("/**");
}
