package com.bxm.newidea.component.config;

import com.bxm.newidea.component.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.jackson.JacksonProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

/**
 * json转化额外处理，增加将lang类型转化为字符串的额外处理
 * 主要是针对前端不支持lang类型大精度，出现精度丢失的问题
 *
 * @author liujia
 */
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties({
    ComponentWebConfigurationProperties.class,
    JacksonProperties.class
})
@Slf4j
public class ComponentWebMessageConverterAutoConfiguration {

    private ComponentWebConfigurationProperties componentWebConfigurationProperties;

    public ComponentWebMessageConverterAutoConfiguration(ComponentWebConfigurationProperties componentWebConfigurationProperties) {
        this.componentWebConfigurationProperties = componentWebConfigurationProperties;
    }

    @Bean
    public MappingJackson2HttpMessageConverter jsonConverter(ObjectMapper objectMapper) {
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();
        jsonConverter.setObjectMapper(objectMapper);

        List<MediaType> supportedMediaTypes = new ArrayList<>();
        supportedMediaTypes.add(new MediaType(MediaType.TEXT_PLAIN, Charset.forName("UTF-8")));
        supportedMediaTypes.add(new MediaType(MediaType.APPLICATION_JSON, Charset.forName("UTF-8")));

        jsonConverter.setSupportedMediaTypes(supportedMediaTypes);

        if (componentWebConfigurationProperties.isJsonConvertLangType()) {
            // 将长整型转化为字符串，解决前端长整型精度丢失的问题
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addSerializer(Long.class, ToStringSerializer.instance);
            simpleModule.addSerializer(long.class, ToStringSerializer.instance);
            simpleModule.addSerializer(Long.TYPE, ToStringSerializer.instance);
            objectMapper.registerModule(simpleModule);
            log.info("启用了json转化中将lang类型转化为字符串的功能");
        }

        if (componentWebConfigurationProperties.isUseUnifiedObjectMapper()) {
            // 额外注册使用内部的统一的objectMapper
            JSON.registerObjectMapper(objectMapper);
        }

        return jsonConverter;
    }
}
