package com.bxm.newidea.component.exceptions;

import com.bxm.newidea.component.tools.StringUtils;

/**
 * 自定义业务异常
 *
 * @author liujia
 * @date 2020/04/22 11:36
 */
public class BusinessException extends RuntimeException {
    private static String defaultMsg = "业务异常";

    private String bizCode;

    public BusinessException(String bizCode) {
        super(defaultMsg);
        this.bizCode = bizCode;
    }

    public BusinessException(String bizCode, String message) {
        super(StringUtils.isBlank(message) ? defaultMsg : message);
        this.bizCode = bizCode;
    }
}
