/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.controller;

import com.bxm.newidea.component.binder.DateEditor;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;

public class BaseController {
    protected static final String RESULT_KEY = "result";
    protected Logger logger = LogManager.getLogger(this.getClass());

    private static String encodeURIComponent(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, "UTF-8").replaceAll("\\+", "%20");
    }

    @InitBinder
    public void initBinding(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(true));
        binder.registerCustomEditor(Date.class, (PropertyEditor)new DateEditor());
    }

    protected void write(HttpServletResponse response, String content) {
        try {
            response.getWriter().write(content);
            response.getWriter().flush();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
    }

    protected void processDownload(String fileName, HttpServletResponse response) {
        try {
            String dateString = DateFormatUtils.format((Date)new Date(), (String)"EEE, dd MMM yyyy HH:mm:ss z", (TimeZone)TimeZone.getTimeZone("GMT"));
            String contentType = "application/x-download";
            response.setStatus(200);
            response.setHeader("Last-modified", dateString);
            response.setHeader("Connection", "keep-alive");
            response.setHeader("Date", dateString);
            response.setHeader("Cache-Control", "no-cache");
            response.setContentType(contentType);
            String headerValue = "attachment;";
            headerValue = headerValue + " filename=\"" + BaseController.encodeURIComponent(fileName) + "\";";
            headerValue = headerValue + " filename*=utf-8''" + BaseController.encodeURIComponent(fileName);
            response.setHeader("Content-Disposition", headerValue);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("\u6587\u4ef6\u540d\u8f6c\u6362\u53d1\u751f\u5f02\u5e38,\u6587\u4ef6\u540d\u4e3a[{0}]", (Object)fileName);
        }
    }
}

