/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.log;

import com.bxm.newidea.component.tools.WebUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@WebFilter(filterName="zlogContextFilter", urlPatterns={"/**"})
public class LogContextFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(LogContextFilter.class);

    public void init(FilterConfig filterConfig) {
        logger.debug("init log context filter");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        ThreadContext.put((String)"requestIp", (String)WebUtils.getIpAddr((HttpServletRequest)request));
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        ThreadContext.clearAll();
    }
}

