/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.config;

import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.aop.framework.autoproxy.BeanNameAutoProxyCreator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@EnableTransactionManagement
@Configuration
@ConditionalOnMissingBean(name={"transactionInterceptor"})
@ConditionalOnBean(value={DataSource.class})
public class TransactionConfiguration {
    @Bean(name={"transactionInterceptor"})
    public TransactionInterceptor transactionInterceptor(DataSourceTransactionManager platformTransactionManager) {
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor();
        transactionInterceptor.setTransactionManager((PlatformTransactionManager)platformTransactionManager);
        Properties transactionAttributes = new Properties();
        String[] requiredMethod = new String[]{"insert*", "new*", "set*", "add*", "save*", "create*", "push*", "send*", "update*", "write*", "modify*", "execute*", "excute*", "do*", "reg*", "process*", "bind*", "pull*", "batch*", "push*", "reset*", "cosume*", "lock*", "unlock*", "comple*", "change*", "confirm*", "pass*", "commit*", "abandon*", "del*", "call*", "remove*", "cancel*", "destroy*", "shift*", "apply*", "enable*", "disable*", "production*", "trans*", "waitOrder*"};
        String[] supportMethod = new String[]{"get*", "load*", "query*", "find*", "is*", "obtain*", "read*", "exist*"};
        String required = "PROPAGATION_REQUIRED,-Throwable";
        String supports = "PROPAGATION_SUPPORTS,readOnly";
        for (String method : requiredMethod) {
            transactionAttributes.setProperty(method, required);
        }
        for (String method : supportMethod) {
            transactionAttributes.setProperty(method, supports);
        }
        transactionInterceptor.setTransactionAttributes(transactionAttributes);
        return transactionInterceptor;
    }

    @Bean
    public BeanNameAutoProxyCreator transactionAutoProxy() {
        BeanNameAutoProxyCreator transactionAutoProxy = new BeanNameAutoProxyCreator();
        transactionAutoProxy.setProxyTargetClass(true);
        transactionAutoProxy.setBeanNames(new String[]{"*ServiceImpl"});
        transactionAutoProxy.setInterceptorNames(new String[]{"transactionInterceptor"});
        return transactionAutoProxy;
    }
}

