package com.bxm.newidea.component.log;


import com.bxm.newidea.component.util.WebUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * 日志上下文过滤器，用于设置当前请求环境的上下文，用于后续的日志记录与现实
 * @author liujia 2018/3/30 15:20
 */
@Component
@WebFilter(filterName = "zlogContextFilter", urlPatterns = "/**")
public class LogContextFilter implements Filter {

    private static final Logger logger = LoggerFactory.getLogger(LogContextFilter.class);

    @Override
    public void init(FilterConfig filterConfig) {
        logger.debug("init log context filter");
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;

        //设置当前请求的IP
        ThreadContext.put(LogConstant.REQUEST_IP, WebUtils.getIpAddr(request));

        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
        ThreadContext.clearAll();
    }
}
