/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.mvc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.servlet.mvc.condition.RequestCondition;

public class ApiVersionRequestCondition
implements RequestCondition<ApiVersionRequestCondition> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("v(\\d+)/");
    private int apiVersion;

    public ApiVersionRequestCondition(int apiVersion) {
        this.apiVersion = apiVersion;
    }

    public ApiVersionRequestCondition combine(ApiVersionRequestCondition other) {
        return new ApiVersionRequestCondition(other.getApiVersion());
    }

    public ApiVersionRequestCondition getMatchingCondition(HttpServletRequest request) {
        int version;
        Matcher matcher = VERSION_PATTERN.matcher(request.getRequestURI());
        if (matcher.find() && (version = Integer.valueOf(matcher.group(1)).intValue()) >= this.apiVersion) {
            return this;
        }
        return null;
    }

    public int compareTo(ApiVersionRequestCondition other, HttpServletRequest request) {
        return other.getApiVersion() - this.apiVersion;
    }

    public int getApiVersion() {
        return this.apiVersion;
    }
}

