/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.log;

import com.bxm.newidea.component.util.WebUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@WebFilter(filterName="zlogContextFilter", urlPatterns={"/**"})
public class LogContextFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(LogContextFilter.class);

    public void init(FilterConfig filterConfig) {
        logger.debug("init log context filter");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        Object request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        ThreadContext.put((String)"requestIp", (String)WebUtils.getIpAddr(request));
        if (!(request instanceof ContentCachingRequestWrapper)) {
            request = new ContentCachingRequestWrapper((HttpServletRequest)request);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
        ThreadContext.clearAll();
    }

    private class ContentCachingRequestWrapper
    extends HttpServletRequestWrapper {
        private byte[] body;
        private BufferedReader reader;
        private ServletInputStream inputStream;

        private ContentCachingRequestWrapper(HttpServletRequest request) throws IOException {
            super(request);
            this.loadBody(request);
        }

        private void loadBody(HttpServletRequest request) throws IOException {
            this.body = IOUtils.toByteArray((InputStream)request.getInputStream());
            this.inputStream = new RequestCachingInputStream(this.body);
        }

        public ServletInputStream getInputStream() throws IOException {
            return new RequestCachingInputStream(this.body);
        }

        public BufferedReader getReader() throws IOException {
            if (this.reader == null) {
                this.reader = new BufferedReader(new InputStreamReader((InputStream)this.inputStream, this.getCharacterEncoding()));
            }
            return this.reader;
        }

        private class RequestCachingInputStream
        extends ServletInputStream {
            private final ByteArrayInputStream inputStream;

            private RequestCachingInputStream(byte[] bytes) {
                this.inputStream = new ByteArrayInputStream(bytes);
            }

            public int read() {
                return this.inputStream.read();
            }

            public int read(byte[] b) throws IOException {
                return this.inputStream.read(b);
            }

            public boolean isFinished() {
                return this.inputStream.available() == 0;
            }

            public boolean isReady() {
                return true;
            }

            public void setReadListener(ReadListener readlistener) {
            }
        }
    }
}

