/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.util;

import com.bxm.newidea.component.jwt.tools.JwtTokenUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebUtils {
    private static Logger logger = LoggerFactory.getLogger(WebUtils.class);

    private WebUtils() {
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ipAddress = request.getHeader("x-forwarded-for");
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
            ipAddress = request.getHeader("WL-Proxy-Client-IP");
        }
        if ((ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) && ("127.0.0.1".equals(ipAddress = request.getRemoteAddr()) || "0:0:0:0:0:0:0:1".equals(ipAddress))) {
            ipAddress = WebUtils.getLocalRealIp();
        }
        if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
            ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
        }
        return ipAddress;
    }

    public static String getLocalRealIp() {
        String localip = null;
        String netip = null;
        Enumeration<NetworkInterface> netInterfaces = null;
        try {
            netInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            boolean finded = false;
            block2: while (netInterfaces.hasMoreElements() && !finded) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> address = ni.getInetAddresses();
                while (address.hasMoreElements()) {
                    ip = address.nextElement();
                    if (!(ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":"))) {
                        netip = ip.getHostAddress();
                        finded = true;
                        continue block2;
                    }
                    if (!ip.isSiteLocalAddress() || ip.isLoopbackAddress() || ip.getHostAddress().contains(":")) continue;
                    localip = ip.getHostAddress();
                }
            }
            if (netip != null && !"".equals(netip)) {
                return netip;
            }
            return localip;
        }
        catch (SocketException e) {
            logger.warn("\u89e3\u6790\u672c\u673aIP\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return "127.0.0.1";
        }
    }

    public static boolean isAjax(HttpServletRequest request) {
        return "XMLHttpRequest".equals(request.getHeader("X-Requested-With"));
    }

    public static String joinRequestParam(HttpServletRequest request, String joinChar, String ... exludeFields) {
        TreeMap paramMap = Maps.newTreeMap();
        Enumeration paramNames = request.getParameterNames();
        try {
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                if (ArrayUtils.contains((Object[])exludeFields, (Object)paramName)) continue;
                String afterReplace = WebUtils.replacer(request.getParameter(paramName));
                paramMap.put(paramName, URLDecoder.decode(afterReplace, StandardCharsets.UTF_8.name()));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        ArrayList keyValues = Lists.newArrayList();
        paramMap.forEach((key, value) -> keyValues.add(key + "=" + value));
        return Joiner.on((String)joinChar).skipNulls().join((Iterable)keyValues);
    }

    private static String replacer(String data) {
        try {
            data = data.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
            data = data.replaceAll("\\+", "%2B");
            data = URLDecoder.decode(data, "utf-8");
        }
        catch (Exception e) {
            logger.error("");
        }
        return data;
    }

    public static String getCurrentUserId() {
        HttpServletRequest request = WebUtils.getRequest();
        if (null != request) {
            String token = request.getHeader("Authorization");
            if (StringUtils.isNotBlank((CharSequence)token)) {
                return JwtTokenUtil.parseToken((String)token);
            }
            return request.getParameter("userId");
        }
        return "";
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
            return servletRequestAttributes.getRequest();
        }
        return null;
    }
}

