package com.bxm.newidea.component.wechat.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.List;
import java.util.Map;

/**
 * 微信公众号的配置
 *
 * @author liujia
 * @date 2020/5/29 13:52
 **/
@ConfigurationProperties(prefix = "thirdparty.wechat.mp")
@Data
public class WechatMpProperties {

    /**
     * 场景和公众号的关联关系
     * key：场景值，在业务方作为参数传递
     * value: 公众号的别名(暂时不考虑一个场景对应多个公众号的情况，后续可以扩展为根据分号分隔，但是得有对应的监控可用性机制)
     */
    private Map<String, String> relation = Maps.newHashMap();

    /**
     * 待选择的公众号，单独配置无效，需要与业务场景绑定
     * {@link StringToWechatMpAccountConverter}
     */
    private List<WechatMpAccount> accounts = Lists.newArrayList();

    /**
     * 默认的，主要的公众号别名，作为匹配失败的默认选择
     */
    private String masterMpAlias;


}
