/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.schedule.rpc;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.component.schedule.ScheduleService;
import com.bxm.newidea.component.schedule.config.ExecutorParam;
import com.bxm.newidea.component.schedule.config.XxlJobConfigurationProperties;
import com.bxm.newidea.component.schedule.rpc.ScheduleFeignService;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    private ScheduleFeignService scheduleFeignService;
    private XxlJobConfigurationProperties properties;
    private static final String VERSION_SHORT_KEY = "v";
    @Value(value="${eureka.instance.metadataMap.version:}")
    private String serviceVersion;

    public ScheduleServiceImpl(XxlJobConfigurationProperties properties, ScheduleFeignService scheduleFeignService) {
        this.properties = properties;
        this.scheduleFeignService = scheduleFeignService;
    }

    @Override
    public boolean push(ScheduleTask task) {
        if (this.validate(task)) {
            if (task.onceTask()) {
                this.scheduleFeignService.update(this.buildTaskName(task), task.cron(), task.description(), this.properties.getAppName(), "beanByNameHandler", this.buildParam(task), task.routeStrategy().name(), task.blockStrategy().name(), task.author());
            } else {
                this.scheduleFeignService.add(this.buildTaskName(task), task.cron(), task.description(), this.properties.getAppName(), "beanByNameHandler", this.buildParam(task), task.routeStrategy().name(), task.blockStrategy().name(), task.author());
            }
            return true;
        }
        return false;
    }

    private String buildTaskName(ScheduleTask task) {
        String version = task.version();
        if (StringUtils.isBlank((String)version)) {
            version = this.properties.getVersion();
        }
        if (StringUtils.isBlank((String)version)) {
            version = this.serviceVersion;
        }
        if (StringUtils.isBlank((String)version)) {
            version = System.getProperty("version");
        }
        if (StringUtils.isNotBlank((String)version) && !StringUtils.startsWithIgnoreCase((String)version, (String)VERSION_SHORT_KEY)) {
            version = StringUtils.startsWithIgnoreCase((String)version, (String)VERSION_SHORT_KEY) ? "_" + version : "_v" + version;
        }
        if (StringUtils.isBlank((String)version)) {
            return task.taskName();
        }
        return task.taskName() + version;
    }

    @Override
    public boolean remove(String taskName) {
        if (StringUtils.isNotBlank((String)taskName)) {
            this.scheduleFeignService.remove(taskName);
            return true;
        }
        return false;
    }

    private String buildParam(ScheduleTask task) {
        return JSON.toJSONString((Object)new ExecutorParam(task.callback().beanName(), task.callbackParam()));
    }

    private boolean validate(ScheduleTask task) {
        if (StringUtils.isBlank((String)task.taskName())) {
            log.error("\u4efb\u52a1\u540d\u672a\u914d\u7f6e");
            return false;
        }
        if (null == task.cron()) {
            log.error("\u4efb\u52a1\u672a\u8bbe\u7f6e\u6267\u884c\u65f6\u95f4");
            return false;
        }
        if (null == task.callback()) {
            log.error("\u4efb\u52a1\u56de\u8c03\u670d\u52a1\u7c7b\u672a\u8bbe\u7f6e");
            return false;
        }
        return true;
    }
}

