/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.schedule.rpc.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.newidea.component.schedule.config.XxlJobConfigurationProperties;
import com.bxm.newidea.component.schedule.rpc.ScheduleFeignService;
import com.bxm.newidea.component.schedule.rpc.param.XxlJobGroup;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduleFeignServiceImpl
implements ScheduleFeignService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleFeignServiceImpl.class);
    private XxlJobConfigurationProperties properties;

    public ScheduleFeignServiceImpl(XxlJobConfigurationProperties properties) {
        this.properties = properties;
    }

    @Override
    public void add(String jobName, String jobCron, String jobDesc, String executorName, String executorHandler, String executorParam, String executorRouteStrategy, String executorBlockStrategy, String author) {
        String addUrl = this.buildPath("facade/jobInfo/add");
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("jobName", jobName);
        paramMap.put("jobCron", jobCron);
        paramMap.put("jobDesc", jobDesc);
        paramMap.put("executorName", executorName);
        paramMap.put("executorHandler", executorHandler);
        paramMap.put("executorParam", executorParam);
        paramMap.put("executorRouteStrategy", executorRouteStrategy);
        paramMap.put("executorBlockStrategy", executorBlockStrategy);
        paramMap.put("author", author);
        String response = OkHttpUtils.postForm((String)addUrl, (Map)paramMap, null);
        log.info("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)paramMap), (Object)response);
    }

    private String buildPath(String uri) {
        if (StringUtils.endsWith((CharSequence)this.properties.getAdminAddresses(), (CharSequence)"/")) {
            return this.properties.getAdminAddresses() + uri;
        }
        return this.properties.getAdminAddresses() + "/" + uri;
    }

    @Override
    public void update(String jobName, String jobCron, String jobDesc, String executorName, String executorHandler, String executorParam, String executorRouteStrategy, String executorBlockStrategy, String author) {
        String addUrl = this.buildPath("facade/jobInfo/update");
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("jobName", jobName);
        paramMap.put("jobCron", jobCron);
        paramMap.put("jobDesc", jobDesc);
        paramMap.put("executorName", executorName);
        paramMap.put("executorHandler", executorHandler);
        paramMap.put("executorParam", executorParam);
        paramMap.put("executorRouteStrategy", executorRouteStrategy);
        paramMap.put("executorBlockStrategy", executorBlockStrategy);
        paramMap.put("author", author);
        String response = OkHttpUtils.postForm((String)addUrl, (Map)paramMap, null);
        log.debug("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)paramMap), (Object)response);
    }

    @Override
    public void remove(String jobName) {
        String addUrl = this.buildPath("facade/jobInfo/remove");
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("jobName", jobName);
        String response = OkHttpUtils.postForm((String)addUrl, (Map)paramMap, null);
        log.info("\u79fb\u9664\u5b9a\u65f6\u4efb\u52a1\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)paramMap), (Object)response);
    }

    @Override
    public void regJobGroup(XxlJobGroup jobGroup) {
        String addUrl = this.buildPath("facade/jobInfo/reg/job");
        String requestBody = JSON.toJSONString((Object)jobGroup);
        String response = OkHttpUtils.postJsonBody((String)addUrl, (String)requestBody, null);
        log.info("\u6ce8\u518c\u6267\u884c\u5668\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)requestBody, (Object)response);
    }
}

