package com.bxm.newidea.component.schedule.builder;

import com.bxm.newidea.component.schedule.constant.XxljobRouteStrategyEnum;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;

/**
 * 周期性运行的任务建造者
 *
 * @author liujia
 */
public class CronTaskBuilder extends InnerTaskAttribute {

    private CronTaskBuilder() {
    }

    public static CronTaskBuilder builder(String taskName, String cron, TaskCallback callback) {
        CronTaskBuilder builder = new CronTaskBuilder();
        builder.taskName = taskName;
        builder.cron = cron;
        builder.callback = callback;
        return builder;
    }

    /**
     * 构建一个运行任务
     *
     * @param cron     运行周期cron表达式
     * @param callback 回调接口，必须注册到spring
     * @return 一次性任务
     */
    public static CronTaskBuilder builder(String cron, TaskCallback callback) {
        CronTaskBuilder task = new CronTaskBuilder();
        task.cron = cron;
        task.callback = callback;
        return task;
    }

    public InnerCronTask build() {
        InnerCronTask task = new InnerCronTask();
        task.cron = this.cron;
        task.taskName = this.taskName;
        task.callback = this.callback;
        task.description = this.description;
        task.param = this.param;
        task.routeStrategy = this.routeStrategy;
        task.blockStrategy = this.blockStrategy;
        task.author = this.author;
        return task;
    }

    /**
     * 调度任务名称，用于在调度平台区分任务信息
     */
    public CronTaskBuilder taskName(String taskName) {
        this.taskName = taskName;
        return this;
    }

    /**
     * 任务触发时间
     */
    public CronTaskBuilder cron(String cron) {
        this.cron = cron;
        return this;
    }

    /**
     * 任务描述，说明调度任务的作用
     */
    public CronTaskBuilder description(String description) {
        this.description = description;
        return this;
    }

    /**
     * 设置调度任务的创建人
     */
    public CronTaskBuilder author(String author) {
        this.author = author;
        return this;
    }

    /**
     * 调度任务的回调接口，在到达任务执行周期时回调
     *
     * @return 回调服务
     */
    public CronTaskBuilder callback(TaskCallback callback) {
        this.callback = callback;
        return this;
    }

    /**
     * 回调时携带的参数，需要在创建调度任务时传递
     */
    public CronTaskBuilder callbackParam(Object param) {
        this.param = param;
        return this;
    }

    /**
     * 任务路由策略，在执行节点存在多个时，决定如何选择执行点
     */
    public CronTaskBuilder routeStrategy(XxljobRouteStrategyEnum routeStrategy) {
        this.routeStrategy = routeStrategy;
        return this;
    }

    /**
     * 阻塞策略，在任务执行时前一个任务尚未完成，后续的任务如何调度
     */
    public CronTaskBuilder blockStrategy(ExecutorBlockStrategyEnum blockStrategy) {
        this.blockStrategy = blockStrategy;
        return this;
    }
}
