package com.bxm.newidea.component.schedule;

import com.bxm.newidea.component.schedule.job.BaseJobHandler;
import com.xxl.job.core.context.XxlJobHelper;
import lombok.extern.slf4j.Slf4j;

/**
 * 周期执行的定时任务
 *
 * @author liujia
 * @date 11/6/21 10:34 PM
 **/
@Slf4j
public abstract class AbstractCronXxlJob extends BaseJobHandler {

    @Override
    public void execute() {
        try {
            executeLogic();
        } catch (Exception e) {
            XxlJobHelper.handleFail(e.getMessage());
            throw e;
        }
        XxlJobHelper.handleSuccess();
    }

    /**
     * 执行业务逻辑
     */
    protected abstract void executeLogic();

    /**
     * 任务执行周期
     *
     * @return cron表达式
     */
    protected abstract String cron();

    @Override
    public final String scheduleConf() {
        return cron();
    }
}
