/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.schedule;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.schedule.AbstractOnceXxlJob;
import com.bxm.newidea.component.schedule.config.ComponentXxlJobExecutor;
import com.bxm.newidea.component.schedule.config.XxlJobConfigurationProperties;
import com.bxm.newidea.component.schedule.config.XxlJobExecutorExtend;
import com.bxm.newidea.component.schedule.model.BaseOnceJobParam;
import com.bxm.newidea.component.schedule.model.CancelOnceJobParam;
import com.bxm.newidea.component.schedule.model.JobPersistentObject;
import com.google.common.base.Preconditions;
import com.xxl.job.core.handler.IJobHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnceJobExecutor {
    private static final Logger log = LoggerFactory.getLogger(OnceJobExecutor.class);
    private XxlJobConfigurationProperties properties;
    private XxlJobExecutorExtend xxlJobExecutorExtend;

    public OnceJobExecutor(XxlJobConfigurationProperties properties, XxlJobExecutorExtend xxlJobExecutorExtend) {
        this.properties = properties;
        this.xxlJobExecutorExtend = xxlJobExecutorExtend;
    }

    public <T extends BaseOnceJobParam> void submit(Class<? extends AbstractOnceXxlJob> onceXxlJobClass, T param) {
        Preconditions.checkNotNull(onceXxlJobClass);
        Preconditions.checkNotNull((Object)param.getJobId());
        Preconditions.checkNotNull((Object)param.getFireDate());
        if (this.properties.isMock()) {
            log.debug("\u6a21\u62df\u72b6\u6001\uff0c\u4e0d\u4e88\u5904\u7406\uff0c\u4efb\u52a1\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString(param));
            return;
        }
        IJobHandler iJobHandler = ComponentXxlJobExecutor.loadJobHandler((String)onceXxlJobClass.getSimpleName());
        if (iJobHandler == null) {
            log.error("{}\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u6267\u884c\u5668\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5c06\u5b83\u6dfb\u52a0\u5230spring context\u4e2d", onceXxlJobClass);
            return;
        }
        JobPersistentObject jobObject = new JobPersistentObject();
        jobObject.setAppName(this.properties.getAppName());
        jobObject.setExecutorName(this.getExecutorName(onceXxlJobClass));
        jobObject.setJobId(this.rebuildJobId(jobObject.getExecutorName(), param.getJobId()));
        jobObject.setFireDate(param.getFireDate().getTime());
        jobObject.setParamJson(JSON.toJSONString(param));
        this.xxlJobExecutorExtend.submitOnceJob(onceXxlJobClass, jobObject);
    }

    public boolean cancel(Class<? extends AbstractOnceXxlJob> onceXxlJobClass, String jobId) {
        Preconditions.checkNotNull(onceXxlJobClass);
        if (this.properties.isMock()) {
            log.debug("\u6a21\u62df\u72b6\u6001\uff0c\u4e0d\u4e88\u5904\u7406\uff0c\u4efb\u52a1ID\uff1a{}", (Object)jobId);
            return true;
        }
        CancelOnceJobParam param = new CancelOnceJobParam();
        param.setAppName(this.properties.getAppName());
        param.setExecutorName(this.getExecutorName(onceXxlJobClass));
        param.setJobId(this.rebuildJobId(param.getExecutorName(), jobId));
        return this.xxlJobExecutorExtend.cancelOnceJob(onceXxlJobClass, param);
    }

    private String rebuildJobId(String executorName, String originJobId) {
        return this.properties.getAppName() + "_" + executorName + "_" + originJobId;
    }

    private String getExecutorName(Class<? extends AbstractOnceXxlJob> onceXxlJobClass) {
        return onceXxlJobClass.getSimpleName();
    }
}

