package com.bxm.newidea.component.schedule;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.schedule.enums.ExecutorRouteStrategyEnum;
import com.bxm.newidea.component.schedule.enums.ScheduleTypeEnum;
import com.bxm.newidea.component.schedule.job.BaseJobHandler;
import com.bxm.newidea.component.schedule.model.BaseOnceJobParam;
import com.bxm.newidea.component.tools.ReflectionUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.xxl.job.core.context.XxlJobHelper;
import lombok.extern.slf4j.Slf4j;

/**
 * 只执行一次的定时任务
 * 实现方式：
 * 注册一个不会执行的handler，通过对xxljob-admin的二次开发，利用它的回调机制来实现多次不定时的触发一个任务
 * <p>
 * 使用方式：
 * 继承当前类，实现一次性调度任务的逻辑。在{@link OnceJobExecutor#submit(Class, BaseOnceJobParam)}中提交
 *
 * @author liujia
 * @date 11/6/21 10:34 PM
 **/
@Slf4j
public abstract class AbstractOnceXxlJob<T> extends BaseJobHandler {

    @Override
    public void execute() {
        try {
            String param = XxlJobHelper.getJobParam();

            T parseParam = null;
            if (StringUtils.isNotBlank(param)) {
                Class<? extends Object> firstGenericType = ReflectionUtils.getFirstGenericType(this.getClass());


                if (null == firstGenericType) {
                    log.error("无法解析json,可以通过指定类泛型信息或覆盖#paramClass()方法实现，当前类型:{}，paramClass()返回结果：{}",
                            this.getClass(),
                            paramClass());
                    return;
                }
                parseParam = (T) JSON.parseObject(param, firstGenericType);
            }

            executeLogic(parseParam);
        } catch (Exception e) {
            XxlJobHelper.handleFail(e.getMessage());
            throw e;
        }
        XxlJobHelper.handleSuccess();
    }

    /**
     * 允许用户覆盖或者强制指定参数的class
     *
     * @return 参数class类型，用于参数转化
     */
    protected Class<? extends Object> paramClass() {
        return null;
    }

    /**
     * 执行业务逻辑
     */
    protected abstract void executeLogic(T parseParam);

    @Override
    public final String jobDesc() {
        return "[一次性任务]" + description();
    }

    /**
     * 任务描述
     *
     * @return 任务描述
     */
    protected abstract String description();

    @Override
    public final ExecutorRouteStrategyEnum executorRouteStrategy() {
        return ExecutorRouteStrategyEnum.FAILOVER;
    }

    @Override
    public final ScheduleTypeEnum scheduleType() {
        return ScheduleTypeEnum.NONE;
    }

    @Override
    public final String scheduleConf() {
        return null;
    }
}
