package com.bxm.newidea.component.schedule.builder;

import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.schedule.constant.XxljobConstant;
import com.bxm.newidea.component.schedule.constant.XxljobRouteStrategyEnum;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.schedule.task.TaskCallback;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.enums.ExecutorBlockStrategyEnum;
import org.apache.commons.lang.StringUtils;


/**
 * 任务基础信息，用于填充公共的字段
 *
 * @author liujia
 */
class InnerBaseTask extends InnerTaskAttribute implements ScheduleTask, TaskCallback {

    @Override
    public String taskName() {
        return this.taskName;
    }

    @Override
    public String cron() {
        return this.cron;
    }

    @Override
    public String description() {
        if (StringUtils.isBlank(this.description)) {
            if (StringUtils.isNotBlank(this.taskName)) {
                return this.taskName;
            } else {
                return XxljobConstant.DEFAULT;
            }
        }
        return this.description;
    }

    @Override
    public TaskCallback<?> callback() {
        return this.callback;
    }

    @Override
    public String callbackParam() {
        if (null == this.param) {
            return StringUtils.EMPTY;
        }
        return JSON.toJSONString(param);
    }

    @Override
    public XxljobRouteStrategyEnum routeStrategy() {
        if (null == this.routeStrategy) {
            return XxljobRouteStrategyEnum.ROUND;
        }
        return this.routeStrategy;
    }

    @Override
    public ExecutorBlockStrategyEnum blockStrategy() {
        if (null == this.blockStrategy) {
            return ExecutorBlockStrategyEnum.SERIAL_EXECUTION;
        }
        return blockStrategy;
    }

    @Override
    public String author() {
        if (StringUtils.isBlank(this.author)) {
            return XxljobConstant.DEFAULT;
        }
        return this.author;
    }

    @Override
    public ReturnT<String> execute(String param) {
        if (null != this.callback) {
            return this.callback.execute(param);
        }
        return ReturnT.FAIL;
    }

    @Override
    public Class paramClass() {
        if (null != param) {
            return param.getClass();
        }
        return null;
    }
}
