package com.bxm.newidea.component.schedule.register.impl;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.newidea.component.JSON;
import com.bxm.newidea.component.schedule.config.XxlJobConfigurationProperties;
import com.bxm.newidea.component.schedule.constant.XxljobConstant;
import com.bxm.newidea.component.schedule.param.ExecutorParam;
import com.bxm.newidea.component.schedule.register.ScheduleRegisterService;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;

import java.util.Map;

/**
 * 使用http请求xxl调度服务
 *
 * @author liujia
 * @date 2020/04/22 16:45
 */
@Slf4j
public class ScheduleRegisterServiceImpl implements ScheduleRegisterService {

    private XxlJobConfigurationProperties properties;

    public ScheduleRegisterServiceImpl(XxlJobConfigurationProperties properties) {
        this.properties = properties;
    }

    private String buildParam(ScheduleTask task) {
        return JSON.toJSONString(new ExecutorParam(task.callback().beanName(), task.callbackParam()));
    }

    @Override
    public void add(ScheduleTask task) {
        String addUrl = buildPath("facade/jobInfo/add");

        Map<String, String> paramMap = createParamMap(task);

        String response = OkHttpUtils.postForm(addUrl, paramMap, null);

        log.info("创建定时任务，请求参数：{}，响应结果：{}", JSON.toJSONString(paramMap), response);
    }

    private String buildPath(String uri) {
        if (StringUtils.endsWith(properties.getAdminAddresses(), "/")) {
            return properties.getAdminAddresses() + uri;
        }
        return properties.getAdminAddresses() + "/" + uri;
    }

    private Map<String, String> createParamMap(ScheduleTask task) {
        Map<String, String> paramMap = Maps.newHashMap();
        paramMap.put("appName", properties.getAppName());
        paramMap.put("jobName", task.taskName());
        paramMap.put("jobCron", task.cron());
        paramMap.put("jobDesc", task.description());
        paramMap.put("executorName", task.taskName());
        paramMap.put("executorHandler", XxljobConstant.HANDLER_NAME);
        paramMap.put("executorParam", buildParam(task));
        paramMap.put("executorRouteStrategy", task.routeStrategy().name());
        paramMap.put("executorBlockStrategy", task.blockStrategy().name());
        paramMap.put("author", task.author());

        return paramMap;
    }

    @Override
    public void update(ScheduleTask task) {
        String addUrl = buildPath("facade/jobInfo/update");

        Map<String, String> paramMap = createParamMap(task);

        String response = OkHttpUtils.postForm(addUrl, paramMap, null);

        log.info("更新定时任务，请求参数：{}，响应结果：{}", JSON.toJSONString(paramMap), response);
    }

    @Override
    public void remove(ScheduleTask task) {
        String addUrl = buildPath("facade/jobInfo/remove");

        Map<String, String> paramMap = Maps.newHashMap();
        paramMap.put("jobName", task.taskName());

        String response = OkHttpUtils.postForm(addUrl, paramMap, null);

        log.info("移除定时任务，请求参数：{}，响应结果：{}", JSON.toJSONString(paramMap), response);
    }
}
