package com.bxm.newidea.component.schedule.service.impl;

import com.bxm.newidea.component.schedule.config.XxlJobConfigurationProperties;
import com.bxm.newidea.component.schedule.register.ScheduleRegisterService;
import com.bxm.newidea.component.schedule.service.ScheduleService;
import com.bxm.newidea.component.schedule.task.ScheduleTask;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;

/**
 * 使用配置中的远程调度服务地址，通过http请求创建、更新、删除定时任务
 *
 * @author liujia
 */
@Slf4j
public class ScheduleServiceImpl implements ScheduleService {

    private ScheduleRegisterService scheduleRegisterService;

    private XxlJobConfigurationProperties properties;

    public ScheduleServiceImpl(ScheduleRegisterService scheduleRegisterService,
                               XxlJobConfigurationProperties properties) {
        this.scheduleRegisterService = scheduleRegisterService;
        this.properties = properties;
    }

    @Override
    public String push(ScheduleTask task) {
        if (!validate(task)) {
            return null;
        }

        //临时性任务要做更新
        if (task.onceTask()) {
            scheduleRegisterService.update(task);
            return null;
        }

        //永久性任务只做新增
        scheduleRegisterService.add(task);
        return null;
    }


    @Override
    public void remove(ScheduleTask task) {
        scheduleRegisterService.remove(task);
    }

    private boolean validate(ScheduleTask task) {
        if (StringUtils.isBlank(task.taskName())) {
            log.error("任务名未配置");
            return false;
        }
        if (null == task.cron()) {
            log.error("任务未设置执行时间");
            return false;
        }
        if (null == task.callback()) {
            log.error("任务回调服务类未设置");
            return false;
        }

        return true;
    }
}

