package com.bxm.newidea.component.schedule;

import com.bxm.newidea.component.schedule.enums.ExecutorRouteStrategyEnum;
import com.bxm.newidea.component.schedule.job.BaseJobHandler;
import com.xxl.job.core.context.XxlJobHelper;
import lombok.extern.slf4j.Slf4j;

/**
 * 支持分片的定时任务
 * 使用方式：
 * 继承该类，根据分片索引和分片总数
 *
 * @author liujia
 * @date 11/6/21 10:34 PM
 **/
@Slf4j
public abstract class AbstractShardingXxlJob extends BaseJobHandler {

    @Override
    public void execute() {
        try {
            executeLogic(XxlJobHelper.getShardIndex(), XxlJobHelper.getShardTotal());
        } catch (Exception e) {
            log.error("定时任务[{}]，执行失败", jobDesc());
            log.error(e.getMessage(), e);
            XxlJobHelper.handleFail(e.getMessage());
            throw e;
        }
        XxlJobHelper.handleSuccess();
    }

    /**
     * 执行具体的业务逻辑
     *
     * @param shardingIndex 分片顺序
     * @param shardingTotal 分片总数
     */
    protected abstract void executeLogic(int shardingIndex, int shardingTotal);

    /**
     * 任务执行周期
     *
     * @return cron表达式
     */
    protected abstract String cron();

    @Override
    public final ExecutorRouteStrategyEnum executorRouteStrategy() {
        // 子类不可再覆盖了，这里必须是分片广播才可以
        return ExecutorRouteStrategyEnum.SHARDING_BROADCAST;
    }

    @Override
    public final String scheduleConf() {
        return cron();
    }
}
