/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.component.zk.config;

import com.bxm.newidea.component.zk.config.ComponentZkConfigurationProperties;
import com.bxm.newidea.component.zk.service.ZookeeperAdapter;
import com.bxm.newidea.component.zk.service.impl.ZookeeperAdapterImpl;
import com.google.common.base.Strings;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.RetryUntilElapsed;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ComponentZkConfigurationProperties.class})
public class ComponentZkConfiguration
implements ApplicationRunner {
    private ComponentZkConfigurationProperties properties;
    private CuratorFramework curatorFramework;

    public ComponentZkConfiguration(ComponentZkConfigurationProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={RetryPolicy.class})
    public RetryPolicy zkRetryPolicy() {
        return new RetryUntilElapsed(5000, 100);
    }

    @Bean
    @ConditionalOnMissingBean(value={CuratorFramework.class})
    @ConditionalOnProperty(prefix="component.zk", name={"url"})
    public CuratorFramework curatorFramework(RetryPolicy retryPolicy) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        builder.connectString(this.properties.getUrl()).connectionTimeoutMs(this.properties.getConnectionTimeout()).sessionTimeoutMs(this.properties.getSessionTimeout()).retryPolicy(retryPolicy);
        if (null != this.properties.getNamespace()) {
            builder.namespace(this.properties.getNamespace());
        }
        if (!Strings.isNullOrEmpty((String)this.properties.getDigest())) {
            builder.authorization("digest", this.properties.getDigest().getBytes(StandardCharsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        this.curatorFramework = builder.build();
        return this.curatorFramework;
    }

    @Bean
    @ConditionalOnMissingBean(value={ZookeeperAdapter.class})
    public ZookeeperAdapter zookeeperAdapter(CuratorFramework curatorFramework) {
        return new ZookeeperAdapterImpl(curatorFramework);
    }

    public void run(ApplicationArguments args) {
        if (this.curatorFramework != null) {
            this.curatorFramework.start();
        }
    }
}

