package com.bxm.newidea.component.zk.listener;

import org.apache.zookeeper.data.Stat;

/**
 * 监听节点变更的相关事件
 *
 * @author liujia
 * @date 6/7/21 12:29 PM
 **/
public interface NodeChangeListener {
    /**
     * 节点发生更新
     *
     * @param path 节点地址
     * @param data 节点数据
     * @param stat 监听的节点的状态信息
     */
    void updated(String path, String data, Stat stat);
}
