package com.bxm.localnews.news.domain;


import com.bxm.localnews.news.model.dto.AdminReplyDTOAdmin;
import com.bxm.localnews.news.model.entity.NewsReplyAllCountInfo;
import com.bxm.localnews.news.model.entity.VirtualReply;
import com.bxm.localnews.news.model.param.AdminAllReplyParam;
import com.bxm.localnews.news.model.param.VirtualReplyListParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

@Mapper
public interface AllReplyMapper {

    /**
     * 查询指定时间内 未审批的评论数据
     *
     * @param startTime 开始时间
     * @param endTime   结束时间
     * @return 未审批的评论数据
     */
    List<NewsReplyAllCountInfo> countAuditReply(@Param("startTime") Date startTime, @Param("endTime") Date endTime);

}
