package com.bxm.localnews.news.model.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.bxm.localnews.news.model.vo.NewsReplyBaseVO;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "次级评论实体")
@Data
public class NewsReplyMirrorDTO extends NewsReplyBaseVO {

    @ApiModelProperty("评论ID")
    private Long id;

    @ApiModelProperty("新闻ID")
    private Long newsId;

    @ApiModelProperty("评论时间")
    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    @JSONField(format = DateUtils.DATE_TIME_FORMAT)
    private Date addTime;

    @ApiModelProperty(hidden = true)
    private Long addTimestamp;

    @ApiModelProperty("是否点赞 1：已点赞 0：未点赞")
    private Integer isLike = 0;

    @ApiModelProperty("回复点赞数")
    private Integer likeCount;

    @ApiModelProperty(value = "删除标记 0：未删除  1：已删除")
    private byte deleteFlag = 0;

    @ApiModelProperty("评论时间")
    private String replyTime;
}
