package com.bxm.localnews.news.model.param;

import com.bxm.newidea.component.param.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

/**
 * @author pf.w
 * @date 2020/11/19 17:45
 **/
@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "评论操作接口上行")
@Data
@Builder
public class ReplyOperateParam extends BasicParam {
    @Tolerate
    public ReplyOperateParam() {
    }

    @ApiModelProperty("用户ID")
    private Long userId;

    @ApiModelProperty("评论ID")
    private Long replyId;

    @ApiModelProperty("帖子ID")
    private Long newsId;

    @ApiModelProperty("操作类型 1：设置仅用户可见  2：设置热门 3：取消热门")
    private Integer operate;

}
