package com.bxm.localnews.news.model.vo;

import com.bxm.egg.common.vo.IUserIdSharding;
import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

@ApiModel(description = "新闻回复持久层实体")
public class UserReply extends NewsReplyBaseVO implements IUserIdSharding {

    @ApiModelProperty("评论ID")
    private Long id;

    @ApiModelProperty("新闻ID")
    private Long newsId;

    @JsonFormat(pattern = DateUtils.DATE_TIME_FORMAT, timezone = "GMT+8")
    private Date addTime;

    @ApiModelProperty("删除标记 0：未删除  1：已删除")
    private byte deleteFlag = 0;

    @ApiModelProperty("回复的根id 直接评论新闻则是0，回复新闻下的评论则显示新闻评论id")
    private Long rootId;

    @ApiModelProperty("回复层次 0:直接评论新闻 1:回复新闻下的评论 2:回复新闻下评论的回复")
    private Byte level;

    @ApiModelProperty("回复点赞数")
    private Integer likeCount;

    @ApiModelProperty("类型：1.新闻  2.小视频")
    private Byte type;

    @ApiModelProperty("状态 0: 待展示; 1: 已展示（审核通过）; 2: 待审核; 3: 审核拒绝; 4: 仅自己可见")
    private Byte status;

    @ApiModelProperty("互动值")
    private Integer interactiveCount;

    @ApiModelProperty("马甲号互动, 0未互动,1已互动")
    private Byte vestInteract;


    public UserReply() {
    }

    public Integer getLikeCount() {
        return likeCount;
    }

    public void setLikeCount(Integer likeCount) {
        this.likeCount = likeCount;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    @Override
    public Byte getStatus() {
        return status;
    }

    @Override
    public void setStatus(Byte status) {
        this.status = status;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public Long getNewsId() {
        return newsId;
    }

    public void setNewsId(Long newsId) {
        this.newsId = newsId;
    }

    public Date getAddTime() {
        return addTime;
    }

    public void setAddTime(Date addTime) {
        this.addTime = addTime;
    }

    public byte getDeleteFlag() {
        return deleteFlag;
    }

    public void setDeleteFlag(byte deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    @Override
    public Long getRootId() {
        return rootId;
    }

    @Override
    public void setRootId(Long rootId) {
        this.rootId = rootId;
    }

    @Override
    public Byte getLevel() {
        return level;
    }

    @Override
    public void setLevel(Byte level) {
        this.level = level;
    }

    public Integer getInteractiveCount() {
        return interactiveCount;
    }

    public void setInteractiveCount(Integer interactiveCount) {
        this.interactiveCount = interactiveCount;
    }

    public Byte getVestInteract() {
        return vestInteract;
    }

    public void setVestInteract(Byte vestInteract) {
        this.vestInteract = vestInteract;
    }
}
