package com.bxm.localnews.enums;

import lombok.Getter;

/**
 * 勋章统计类型表
 *
 * @author wzy
 * @date 2021年03月06日11:11:35
 */
@Getter
public enum UserMedalCounterTypeEnum {
    /**
     * 勋章统计事件类型
     */
    SIGN_MEDAL(1, "签到勋章"),
    POST_MEDAL(2, "帖子勋章"),
    COMMENT_MEDAL(3, "评论勋章"),
    LIKE_MEDAL(4, "点赞勋章"),
    VIEW_POST_MEDAL(5, "浏览帖子"),
    COMPLETE_USER_INFO(6, "完善用户信息勋章");

    UserMedalCounterTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    /**
     * 编码
     */
    private Integer code;

    /**
     * 描述
     */
    private String description;
}
