package com.bxm.localnews.enums;

import lombok.Getter;

/**
 * 勋章的类型枚举
 */
@Getter
public enum UserMedalTypeEnum {

    /*******************定制勋章*******************/
    /**
     * 普通定制勋章
     */
    GENERAL_CUSTOM_MEDAL(0, "普通定制勋章"),

    /*********************成就勋章****************/
    SIGN_MEDAL(1, "签到勋章"),
    POST_MEDAL(2, "帖子勋章"),
    COMMENT_MEDAL(3, "评论勋章"),
    LIKE_MEDAL(4, "点赞勋章"),
    VIEW_POST_MEDAL(5, "浏览帖子"),
    COMPLETE_USER_INFO(6, "完善用户信息勋章");

    UserMedalTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    /**
     * 编码
     */
    private Integer code;

    /**
     * 描述
     */
    private String description;
}
