package com.bxm.localnews.user.event;

import com.bxm.localnews.user.enums.UserActionEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 冗余信息更新
 *
 * @author liujia
 * @date 2020-07-16 14:55
 **/
@EqualsAndHashCode(callSuper = true)
@Data(staticConstructor = "of")
@Accessors(chain = true)
public class RedundancyActionEvent extends UserActionEvent {

    /**
     * 用户行为
     */
    private final UserActionEnum action = UserActionEnum.REDUNDANCY;

    /**
     * 用户昵称变更
     */
    private String nickName;

    /**
     * 用户头像变更
     */
    private String headImg;
}
