/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.facade.dto.LocationDetailDTO;
import com.bxm.egg.facade.service.LocationFacadeService;
import com.bxm.localnews.integration.InnerServiceIntegrationService;
import com.bxm.localnews.news.constant.GlobalConstant;
import com.bxm.localnews.news.dto.LocationDTO;
import com.bxm.localnews.news.model.dto.AreaCode;
import com.bxm.localnews.news.vo.Location;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class LocationIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(LocationIntegrationService.class);
    private LoadingCache<String, LocationDTO> cache;
    private final LocationFacadeService locationFacadeService;

    public LocationIntegrationService(InnerServiceIntegrationService innerServiceIntegrationService) {
        this.locationFacadeService = innerServiceIntegrationService.getLocationFacadeService();
    }

    @PostConstruct
    public void buildCache() {
        this.cache = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, LocationDTO>(){

            public LocationDTO load(String key) {
                LocationDTO location = new LocationDTO();
                if (GlobalConstant.GLOBAL_AREA.equals(key) || GlobalConstant.GLOBAL_AREA_FULL.equals(key)) {
                    location.setCode(GlobalConstant.GLOBAL_AREA);
                    location.setName("\u5168\u56fd");
                    return location;
                }
                LocationDetailDTO detailDTO = LocationIntegrationService.this.locationFacadeService.getLocationDetailByCode(key);
                if (null == detailDTO) {
                    location.setCode(key);
                    location.setName("\u672a\u77e5");
                } else {
                    location.setCode(key);
                    location.setName(detailDTO.getName());
                }
                return location;
            }
        });
    }

    public LocationDTO getLocationByGeocode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return new LocationDTO();
        }
        return (LocationDTO)this.cache.getUnchecked((Object)code);
    }

    public List<Location> batchFetch(List<String> codes) {
        ArrayList locations = Lists.newArrayList();
        for (String locationCode : codes) {
            LocationDTO locationDTO = this.getLocationByGeocode(locationCode);
            locations.add(this.convert(locationDTO));
        }
        return locations;
    }

    private Location convert(LocationDTO locationDTO) {
        Location location = new Location();
        BeanUtils.copyProperties((Object)locationDTO, (Object)location);
        return location;
    }

    public String batchGetDetailJson(String[] areaCodes) {
        return this.batchGetDetailJson(Lists.newArrayList((Object[])areaCodes));
    }

    public String batchGetDetailJson(List<String> areaCodes) {
        ArrayList<AreaCode> areaCodeList = new ArrayList<AreaCode>();
        for (String areaCode : areaCodes) {
            LocationDTO locationDTO = this.getLocationByGeocode(areaCode);
            AreaCode areaInfo = new AreaCode();
            areaInfo.setAreaCode(locationDTO.getCode());
            areaInfo.setAreaName(locationDTO.getName());
            areaCodeList.add(areaInfo);
        }
        return JSON.toJSONString(areaCodeList);
    }
}

