/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.mq.common.constant.MessageFilterEventTypeEnum;
import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.egg.mq.common.constant.TemplateTypeEnum;
import com.bxm.egg.mq.common.model.dto.MessageFilterInfo;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.mq.common.model.dto.PushPayloadInfo;
import com.bxm.egg.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.integration.InnerServiceIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.factory.ExtendFactory;
import com.bxm.localnews.news.model.param.NewsReplyLikeParam;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import com.bxm.localnews.news.model.vo.NewsReply;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MessageService {
    private static final Logger log = LoggerFactory.getLogger(MessageService.class);
    private UserIntegrationService userIntegrationService;
    private MessageFacadeService messageFacadeService;

    public MessageService(UserIntegrationService userIntegrationService, InnerServiceIntegrationService innerServiceIntegrationService) {
        this.userIntegrationService = userIntegrationService;
        this.messageFacadeService = innerServiceIntegrationService.getMessageFacadeService();
    }

    public void pushMessage(PushMessage pushMessage) {
        this.messageFacadeService.sendPushMessage(pushMessage);
    }

    public void addMessage(PushMessage pushMessage, Long userId) {
        pushMessage.getPayloadInfo().addTargetUserId(userId);
        this.messageFacadeService.sendUserMessage(pushMessage);
    }

    public void pushPostReplyMessage(NewsReply newsReply, ForumPostVo forumPostVo) {
        if (null != forumPostVo && !newsReply.getUserId().equals(forumPostVo.getUserId())) {
            String pushContent = ExtendFactory.getPushContent((String)newsReply.getReplyContent());
            String title = newsReply.getUserNickname() + "\u7ed9\u4f60\u8bc4\u8bba\u4e86";
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.BELONG_POST_REPLY);
            Long msgId = SequenceHolder.nextLongId();
            info.setMsgId(msgId);
            info.addExtend("msgId", (Object)msgId);
            info.addExtend("newsId", (Object)newsReply.getNewsId());
            info.addExtend("postId", (Object)newsReply.getNewsId());
            info.addExtend("title", (Object)title);
            info.addExtend("replyId", (Object)newsReply.getId());
            info.addExtend("icon", (Object)newsReply.getHeadImg());
            info.addExtend("nickname", (Object)newsReply.getUserNickname());
            info.addExtend("action", (Object)"\u7ed9\u4f60\u8bc4\u8bba\u4e86");
            info.addExtend("type", (Object)"3");
            info.addExtend("postTitle", (Object)ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
            info.addExtend("replyContent", (Object)pushContent);
            info.addExtend("hasImg", (Object)StringUtils.isNotBlank((CharSequence)newsReply.getReplyImg()));
            info.setType(PushMessageEnum.POST_REPLY.getType());
            this.fillExtendUrlOrContent(forumPostVo, info);
            PushMessage message = PushMessage.build();
            message.setTitle(title);
            message.setContent(newsReply.getReplyContent());
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)forumPostVo.getUserId()));
            message.setPayloadInfo(info);
            this.addMessage(message, forumPostVo.getUserId());
        }
    }

    public void pushPostReplyATMessage(NewsReply newsReply, ForumPostVo forumPostVo, List<Long> userIds) {
        if (null != forumPostVo && !CollectionUtils.isEmpty(userIds)) {
            String title = newsReply.getUserNickname() + "\u5728\u8bc4\u8bba\u4e2d@\u4e86\u4f60";
            PushPayloadInfo info = Objects.equals(newsReply.getLevel(), (byte)0) ? PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.AT) : PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.AT_SUB);
            info.addExtend("newsId", (Object)newsReply.getNewsId());
            info.addExtend("postId", (Object)newsReply.getNewsId());
            info.addExtend("title", (Object)title);
            info.addExtend("replyId", (Object)newsReply.getId());
            info.addExtend("icon", (Object)newsReply.getHeadImg());
            info.addExtend("nickname", (Object)newsReply.getUserNickname());
            info.addExtend("action", (Object)"\u5728\u8bc4\u8bba\u4e2d@\u4e86\u4f60");
            info.addExtend("type", (Object)"3");
            info.addExtend("postTitle", (Object)ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
            info.addExtend("replyContent", (Object)newsReply.getReplyContentHtml());
            info.addExtend("hasImg", (Object)StringUtils.isNotBlank((CharSequence)newsReply.getReplyImg()));
            this.fillExtendUrlOrContent(forumPostVo, info);
            PushMessage message = PushMessage.build();
            message.setTitle(title);
            message.setContent(newsReply.getReplyContentHtml());
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPayloadInfo(info);
            userIds.forEach(userId -> {
                message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
                this.addMessage(message, (Long)userId);
            });
            PushMessage pushMsg = PushMessage.build();
            PushPayloadInfo pushInfo = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
            pushInfo.setProtocol("egg://message/messageList?title=%40%e6%88%91%e7%9a%84&type=AT_ME");
            pushMsg.setPayloadInfo(pushInfo);
            pushMsg.setTitle(title);
            pushMsg.setContent(newsReply.getReplyContent());
            pushMsg.setType(TemplateTypeEnum.NOTIFCTION);
            pushMsg.setPersistence(false);
            pushMsg.setPushReceiveScope(PushReceiveScope.pushGroup(userIds));
            this.pushMessage(pushMsg);
        }
    }

    private void fillExtendUrlOrContent(ForumPostVo forumPostVo, PushPayloadInfo info) {
        List img = forumPostVo.getPostImgList();
        if (!CollectionUtils.isEmpty((Collection)img)) {
            info.addExtend("extendUrl", (Object)((PostImgVo)img.get(0)).getImgUrl());
        } else {
            info.addExtend("extendContent", (Object)ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
        }
    }

    public void pushNewReplyMessage(NewsReply newsReply, PushMessageEnum pushMessageEnum, ForumPostVo forumPostVo) {
        UserBean userEntity;
        if (newsReply.getParentId() != 0L && Objects.nonNull(newsReply.getParentUserId()) && newsReply.getParentUserId() != 0L && Objects.nonNull(userEntity = this.userIntegrationService.selectUserFromCache(newsReply.getParentUserId()))) {
            String pushContent = ExtendFactory.getPushContent((String)(StringUtils.isBlank((CharSequence)newsReply.getReplyContent()) && StringUtils.isNotBlank((CharSequence)newsReply.getReplyImg()) ? "\u67e5\u770b\u56fe\u7247" : newsReply.getReplyContent()));
            String title = newsReply.getUserNickname() + "\u56de\u590d\u4e86\u4f60\u7684\u8bc4\u8bba";
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)pushMessageEnum);
            Long msgId = SequenceHolder.nextLongId();
            info.setMsgId(msgId);
            info.addExtend("msgId", (Object)msgId);
            info.addExtend("icon", (Object)newsReply.getHeadImg());
            info.addExtend("replyId", (Object)newsReply.getId());
            info.addExtend("title", (Object)title);
            info.addExtend("newsId", (Object)newsReply.getNewsId());
            info.addExtend("type", (Object)"3");
            info.addExtend("nickname", (Object)newsReply.getUserNickname());
            info.addExtend("action", (Object)"\u56de\u590d\u4e86\u4f60\u7684\u8bc4\u8bba");
            info.addExtend("replyContent", (Object)pushContent);
            info.addExtend("hasImg", (Object)StringUtils.isNotBlank((CharSequence)newsReply.getReplyImg()));
            this.addPushPayloadInfo(newsReply, info, forumPostVo);
            PushMessage message = PushMessage.build();
            message.setTitle(title);
            if (newsReply.getDeleteFlag() == 0) {
                message.setContent(pushContent);
            } else {
                message.setContent("\u8be5\u8bc4\u8bba\u5df2\u5220\u9664\uff01");
            }
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)newsReply.getParentUserId()));
            message.setPayloadInfo(info);
            this.addMessage(message, newsReply.getParentUserId());
        }
    }

    public void sendMessageFilterForReply(Long userId, Long replyId) {
        MessageFilterInfo info = new MessageFilterInfo();
        info.setEventTypeEnum(MessageFilterEventTypeEnum.COMMENT_REPLY_DELETE_EVENT);
        info.setLogicId(replyId);
        info.setUserId(userId);
        this.messageFacadeService.sendMsgFilterEvent(info);
    }

    public void pushPostLikeMessage(ForumPostVo forumPostVo, UserBean likeUser) {
        UserBean receiveUserEntity = this.userIntegrationService.selectUserFromCache(forumPostVo.getUserId());
        if (Objects.isNull(receiveUserEntity) || !Objects.equals(receiveUserEntity.getState(), (byte)1)) {
            return;
        }
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.BELONG_POST_LIKE);
        Long msgId = SequenceHolder.nextLongId();
        String title = likeUser.getNickname() + "\u70b9\u8d5e\u4e86\u4f60\u7684\u5e16\u5b50";
        info.addExtend("action", (Object)"\u70b9\u8d5e\u4e86\u4f60\u7684\u5e16\u5b50");
        info.setMsgId(msgId);
        info.addExtend("msgId", (Object)msgId);
        info.addExtend("postId", (Object)forumPostVo.getId());
        info.addExtend("title", (Object)title);
        info.addExtend("icon", (Object)likeUser.getHeadImg());
        info.addExtend("nickname", (Object)likeUser.getNickname());
        info.addExtend("type", (Object)"3");
        info.addExtend("postTitle", (Object)ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
        this.fillExtendUrlOrContent(forumPostVo, info);
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)forumPostVo.getUserId()));
        message.setPayloadInfo(info);
        this.addMessage(message, forumPostVo.getUserId());
    }

    private void addPushPayloadInfo(NewsReply newsReply, PushPayloadInfo info, ForumPostVo forumPostVo) {
        if (newsReply.getType() == 3) {
            if (!CollectionUtils.isEmpty((Collection)forumPostVo.getPostImgList())) {
                info.addExtend("extendUrl", (Object)((PostImgVo)forumPostVo.getPostImgList().get(0)).getImgUrl());
            } else {
                info.addExtend("extendContent", (Object)ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
            }
        }
    }

    public void pushNewLikeMessage(NewsReplyLikeParam newsReplyLikeParam, PushMessageEnum pushMessageEnum, NewsReply newsReply, ForumPostVo forumPostVo) {
        UserBean userEntity;
        if (newsReplyLikeParam.getUserId() != 0L && Objects.nonNull(userEntity = this.userIntegrationService.selectUserFromCache(newsReplyLikeParam.getUserId()))) {
            String title = userEntity.getNickname() + "\u70b9\u8d5e\u4e86\u4f60\u7684\u8bc4\u8bba";
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)pushMessageEnum);
            info.addExtend("icon", (Object)userEntity.getHeadImg());
            info.addExtend("replyId", (Object)newsReplyLikeParam.getReplyId());
            info.addExtend("title", (Object)title);
            if (null != newsReplyLikeParam.getNewsId()) {
                info.addExtend("newsId", (Object)newsReplyLikeParam.getNewsId());
            }
            info.addExtend("type", (Object)newsReply.getType());
            info.addExtend("nickname", (Object)userEntity.getNickname());
            info.addExtend("action", (Object)"\u70b9\u8d5e\u4e86\u4f60\u7684\u8bc4\u8bba");
            info.addExtend("replyContent", (Object)newsReply.getReplyContent());
            this.addPushPayloadInfo(newsReply, info, forumPostVo);
            PushMessage message = PushMessage.build();
            message.setTitle(title);
            if (newsReply.getDeleteFlag() == 0) {
                message.setContent(newsReply.getReplyContent());
            } else {
                message.setContent("\u8be5\u8bc4\u8bba\u5df2\u5220\u9664!");
            }
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)newsReply.getUserId()));
            message.setPayloadInfo(info);
            this.addMessage(message, newsReply.getUserId());
            if (log.isDebugEnabled()) {
                log.debug("\u7528\u6237[{}]\u70b9\u8d5e\u4e86\u7528\u6237[{}]\u7684\u8bc4\u8bba\uff0c\u7ed9\u7528\u6237[{}]\u53d1\u9001\u63a8\u9001,\u63a8\u9001\u7c7b\u578b\u4e3a[{}]\uff0c \n\u63a8\u9001\u7684\u6570\u636e\uff1a[{}]", new Object[]{newsReplyLikeParam.getUserId(), newsReply.getUserId(), newsReply.getUserId(), pushMessageEnum.getType(), JSON.toJSONString((Object)message)});
            }
        }
    }

    public void pushPostReply(UserBean sendUser, String title, ForumPostVo postVo, UserBean replyUser) {
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.BELONG_POST_REPLY);
        Long msgId = SequenceHolder.nextLongId();
        info.setMsgId(msgId);
        info.addExtend("msgId", (Object)msgId);
        info.addExtend("newsId", (Object)postVo.getId());
        info.addExtend("postId", (Object)postVo.getId());
        info.addExtend("icon", (Object)replyUser.getHeadImg());
        info.addExtend("nickname", (Object)replyUser.getNickname());
        info.addExtend("action", (Object)title);
        info.addExtend("type", (Object)ReplyTypeEnum.POST_REPLY.getCode());
        info.addExtend("postTitle", (Object)ExtendFactory.getPostContent((String)postVo.getTitle(), (String)postVo.getTextField()));
        this.fillExtendUrlOrContent(postVo, info);
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)sendUser.getId()));
        message.setPayloadInfo(info);
        this.addMessage(message, sendUser.getId());
    }
}

