/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.bxm.egg.common.url.ProtocolFactory;
import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.egg.mq.common.constant.TemplateTypeEnum;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.mq.common.model.dto.PushPayloadInfo;
import com.bxm.egg.mq.common.model.dto.PushReceiveScope;
import com.bxm.foundation.base.facade.service.DomainFacadeService;
import com.bxm.localnews.integration.InnerServiceIntegrationService;
import com.bxm.localnews.news.model.bo.ForumPostDetailBO;
import com.bxm.localnews.news.model.entity.ForumPostEntity;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PushMsgService {
    private static final Logger log = LoggerFactory.getLogger(PushMsgService.class);
    private DomainFacadeService domainIntegrationService;
    private MessageFacadeService messageFacadeService;

    public PushMsgService(InnerServiceIntegrationService innerServiceIntegrationService) {
        this.messageFacadeService = innerServiceIntegrationService.getMessageFacadeService();
        this.domainIntegrationService = innerServiceIntegrationService.getDomainFacadeService();
    }

    public void pushMsg(PushMessage message) {
        this.messageFacadeService.sendPushMessage(message);
    }

    private String getPostProtocolUrl(Long postId) {
        return ProtocolFactory.forumPost().app().postId(postId).build();
    }

    public void pushPostDeleteMsg(ForumPostEntity postEntity, Long targetPostId) {
        String title = postEntity.getBrief();
        title = title.length() > 8 ? title.substring(0, 8) : title;
        String content = "\u62b1\u6b49\uff0c\u4f60\u7684\u4fe1\u606f\u300c" + title + "\u300d\u5df2\u88ab\u7ba1\u7406\u5458\u5220\u9664\u3002\u4e3a\u7ed9\u5708\u53cb\u63d0\u4f9b\u66f4\u4f18\u8d28\u7684\u5185\u5bb9\u548c\u793e\u533a\u6c1b\u56f4\uff0c\u6211\u4eec\u4f1a\u5c06\u4e00\u4e9b\u5185\u5bb9\u8fdd\u89c4\u6216\u8d28\u91cf\u8f83\u4f4e\u7684\u4fe1\u606f\u4f5c\u5220\u9664\u5904\u7406\uff0c\u611f\u8c22\u4f60\u7684\u7406\u89e3";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        Long msgId = SequenceHolder.nextLongId();
        info.setMsgId(msgId);
        info.setProtocol(this.getPostProtocolUrl(targetPostId));
        info.addExtend("msgId", (Object)msgId);
        info.addExtend("postId", (Object)postEntity.getId());
        PushMessage message = PushMessage.build();
        message.setTitle("\u4fe1\u606f\u5df2\u88ab\u5220\u9664");
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)postEntity.getUserId()));
        message.setPayloadInfo(info);
        this.pushMsg(message);
    }

    public void pushPostRejectMsg(ForumPostDetailBO post, Long targetPostId) {
        String title = post.getPostInfo().getBrief();
        title = title.length() > 8 ? title.substring(0, 8) : title;
        String content = "\u62b1\u6b49\uff0c\u4f60\u7684\u4fe1\u606f\u300c" + title + "\u300d\u88ab\u5904\u7406\u4e3a\u8fdd\u89c4\u4fe1\u606f\u3002\u4e3a\u7ed9\u5708\u53cb\u63d0\u4f9b\u66f4\u4f18\u8d28\u7684\u5185\u5bb9\u548c\u793e\u533a\u6c1b\u56f4\uff0c\u6211\u4eec\u4f1a\u5c06\u4e00\u4e9b\u5185\u5bb9\u8fdd\u89c4\u6216\u8d28\u91cf\u8f83\u4f4e\u7684\u4fe1\u606f\u4f5c\u5904\u7406\uff0c\u611f\u8c22\u4f60\u7684\u7406\u89e3";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        Long msgId = SequenceHolder.nextLongId();
        info.setMsgId(msgId);
        info.setProtocol(this.getPostProtocolUrl(targetPostId));
        info.addExtend("msgId", (Object)msgId);
        info.addExtend("postId", (Object)post.getPostInfo().getId());
        PushMessage message = PushMessage.build();
        message.setTitle("\u4f60\u7684\u4fe1\u606f\u5df2\u8fdd\u89c4");
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)post.getPostInfo().getUserId()));
        message.setPayloadInfo(info);
        this.pushMsg(message);
    }

    public void pushReplyDeleteAndRejectMsg(String reply, Long userId, Long targetPostId) {
        String title = reply.length() > 8 ? reply.substring(0, 8) : reply;
        title = StringUtils.isBlank((CharSequence)title) ? "\u67e5\u770b\u56fe\u7247" : title;
        String content = "\u7ecf\u4e3e\u62a5\u548c\u5ba1\u6838\uff0c\u4f60\u7684\u8bc4\u8bba\u300c" + title + "\u300d\u8fdd\u53cd\u86cb\u86cb\u4f73\u7ba1\u7406\u89c4\u5b9a\uff0c\u5df2\u88ab\u5220\u9664\u3002\u611f\u8c22\u4f60\u7684\u7406\u89e3\u3002";
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.JUMP_TYPE);
        Long msgId = SequenceHolder.nextLongId();
        info.setMsgId(msgId);
        info.setProtocol(this.getPostProtocolUrl(targetPostId));
        info.addExtend("msgId", (Object)msgId);
        info.addExtend("replyId", (Object)targetPostId);
        PushMessage message = PushMessage.build();
        message.setTitle("\u8bc4\u8bba\u5df2\u88ab\u5220\u9664");
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)userId));
        message.setPayloadInfo(info);
        this.pushMsg(message);
    }
}

