/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.bxm.egg.user.dto.auth.UserAuthCodeDTO;
import com.bxm.egg.user.enums.AuthCodeEnum;
import com.bxm.egg.user.facade.service.UserAuthFacadeService;
import com.bxm.localnews.integration.InnerServiceIntegrationService;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.tools.BitOperatorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserAuthIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(UserAuthIntegrationService.class);
    private UserAuthFacadeService userAuthFacadeService;

    public UserAuthIntegrationService(InnerServiceIntegrationService innerServiceIntegrationService) {
        this.userAuthFacadeService = innerServiceIntegrationService.getUserAuthFacadeService();
    }

    public Message hasPostAuth(Long userId) {
        UserAuthCodeDTO userAuth = this.userAuthFacadeService.getUserAuth(userId);
        if (null == userAuth || userAuth.getCombineAuthCode() == null) {
            return Message.build();
        }
        if (BitOperatorUtil.hasBit((Long[])userAuth.getCombineAuthCode(), (int)AuthCodeEnum.FORBID_POST.index)) {
            log.info("{}\u5c1d\u8bd5\u53d1\u5e16\uff0c\u56e0\u65e0\u6743\u88ab\u62d2\u7edd", (Object)userAuth);
            return Message.build((boolean)false, (String)"\u60a8\u5df2\u88ab\u7981\u6b62\u53d1\u5e16\uff0c\u8be6\u60c5\u8bf7\u54a8\u8be2\u5ba2\u670d\u4eba\u5458");
        }
        return Message.build();
    }

    public Message hasCommentAuth(Long userId) {
        UserAuthCodeDTO userAuth = this.userAuthFacadeService.getUserAuth(userId);
        if (null == userAuth || userAuth.getCombineAuthCode() == null) {
            return Message.build();
        }
        if (BitOperatorUtil.hasBit((Long[])userAuth.getCombineAuthCode(), (int)AuthCodeEnum.FORBID_COMMENT.index)) {
            log.info("{}\u5c1d\u8bd5\u8bc4\u8bba\uff0c\u56e0\u65e0\u6743\u88ab\u62d2\u7edd", (Object)userAuth);
            return Message.build((boolean)false, (String)"\u60a8\u5df2\u88ab\u7981\u6b62\u8bc4\u8bba\uff0c\u8be6\u60c5\u8bf7\u54a8\u8be2\u5ba2\u670d\u4eba\u5458");
        }
        return Message.build();
    }
}

