/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.bxm.egg.user.enums.OperateTypeEnum;
import com.bxm.egg.user.enums.UserStatisticsTypeEnum;
import com.bxm.egg.user.facade.bo.UserInfoBO;
import com.bxm.egg.user.facade.bo.UserStatisticsBO;
import com.bxm.egg.user.facade.param.UserStatisticsOperateParam;
import com.bxm.egg.user.facade.service.UserInfoFacadeService;
import com.bxm.egg.user.facade.service.UserStatisticsFacadeService;
import com.bxm.localnews.converter.IntegrationConverter;
import com.bxm.localnews.dto.UserRegisterInfoDTO;
import com.bxm.localnews.integration.InnerServiceIntegrationService;
import com.bxm.localnews.news.constant.MemoryCacheKey;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.sync.core.SyncCacheAgent;
import com.bxm.newidea.component.sync.core.SyncCacheHolderFactory;
import com.bxm.newidea.component.sync.key.SyncCacheKey;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UserIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(UserIntegrationService.class);
    private final UserInfoFacadeService userInfoFacadeService;
    private UserStatisticsFacadeService userStatisticsFacadeService;

    public UserIntegrationService(InnerServiceIntegrationService innerServiceIntegrationService) {
        this.userInfoFacadeService = innerServiceIntegrationService.getUserInfoFacadeService();
        this.userStatisticsFacadeService = innerServiceIntegrationService.getUserStatisticsFacadeService();
    }

    private UserBean loadUser(Long userId) {
        UserInfoBO userInfoBO = this.userInfoFacadeService.selectUserFromCache(userId);
        return IntegrationConverter.INSTANCE.of(userInfoBO);
    }

    public UserBean selectUserFromCache(Long userId) {
        if (null != userId) {
            SyncCacheAgent cacheAgent = SyncCacheHolderFactory.build((SyncCacheKey)MemoryCacheKey.USER_LOCAL_CACHE, this::loadUser);
            return (UserBean)cacheAgent.get((Object)userId);
        }
        UserBean user = new UserBean();
        user.setId(userId);
        return user;
    }

    public UserStatisticsBO getUserStatisticsInfo(Long userId) {
        return this.userInfoFacadeService.getUserStatisticsInfo(userId);
    }

    public List<UserBean> batchUserInfo(List<Long> userIdList) {
        List userInfoBOList = this.userInfoFacadeService.selectUserListFromCache(userIdList);
        return IntegrationConverter.INSTANCE.of(userInfoBOList);
    }

    public void addUserStatisticsNum(Long userId, Integer type) {
        UserStatisticsOperateParam param = new UserStatisticsOperateParam();
        param.setUserId(userId);
        param.setOperateNum(Integer.valueOf(1));
        if (Objects.equals(type, 2)) {
            param.setOperateTypeEnum(OperateTypeEnum.REDUCE);
            param.setUserStatisticsType(UserStatisticsTypeEnum.POST_NUM);
        } else if (Objects.equals(type, 1)) {
            param.setOperateTypeEnum(OperateTypeEnum.INCREASE);
            param.setUserStatisticsType(UserStatisticsTypeEnum.POST_NUM);
        } else if (Objects.equals(type, 3)) {
            param.setOperateTypeEnum(OperateTypeEnum.INCREASE);
            param.setUserStatisticsType(UserStatisticsTypeEnum.REPLY_NUM);
        } else if (Objects.equals(type, 4)) {
            param.setOperateTypeEnum(OperateTypeEnum.REDUCE);
            param.setUserStatisticsType(UserStatisticsTypeEnum.REPLY_NUM);
        }
        this.userStatisticsFacadeService.operateUserStatistics(param);
    }

    @Async
    public void updateUserLikeNumByUserId(Long userId) {
        UserStatisticsOperateParam param = new UserStatisticsOperateParam();
        param.setUserId(userId);
        param.setOperateNum(Integer.valueOf(1));
        param.setOperateTypeEnum(OperateTypeEnum.INCREASE);
        param.setUserStatisticsType(UserStatisticsTypeEnum.LIKE_NUM);
        this.userStatisticsFacadeService.operateUserStatistics(param);
    }

    public UserRegisterInfoDTO userRegisterInfo(Long userId) {
        return null;
    }
}

