/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.bxm.foundation.user.facade.VirtualUserFacadeService;
import com.bxm.foundation.user.facade.dto.VirtualUserDTO;
import com.bxm.foundation.user.facade.param.VirtualUserQueryParam;
import com.bxm.localnews.integration.InnerServiceIntegrationService;
import com.bxm.localnews.news.model.dto.VirtualUserOverviewDTO;
import com.bxm.localnews.news.model.param.VirtualUserRandomQueryParam;
import com.bxm.localnews.news.model.vo.VirtualUser;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class VirtualUserIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(VirtualUserIntegrationService.class);
    private VirtualUserFacadeService virtualUserFacadeService;
    private LoadingCache<Long, VirtualUserOverviewDTO> cache;

    public VirtualUserIntegrationService(InnerServiceIntegrationService innerServiceIntegrationService) {
        this.virtualUserFacadeService = innerServiceIntegrationService.getVirtualUserFacadeService();
    }

    public Boolean exists(Long userId) {
        return userId < 0L;
    }

    public List<VirtualUser> getRandom(VirtualUserRandomQueryParam param) {
        VirtualUserQueryParam facadeParam = new VirtualUserQueryParam();
        facadeParam.setAcquireNum(param.getNum());
        facadeParam.setSrcApp("egg");
        List randomList = this.virtualUserFacadeService.getRandom(facadeParam);
        return randomList.stream().map(this::of).collect(Collectors.toList());
    }

    public List<VirtualUser> getRandom(Integer num) {
        VirtualUserQueryParam facadeParam = new VirtualUserQueryParam();
        facadeParam.setAcquireNum(num);
        facadeParam.setSrcApp("egg");
        List randomList = this.virtualUserFacadeService.getRandom(facadeParam);
        return randomList.stream().map(this::of).collect(Collectors.toList());
    }

    private VirtualUser of(VirtualUserDTO userDTO) {
        VirtualUser virtualUser = new VirtualUser();
        virtualUser.setId(userDTO.getUserId());
        virtualUser.setHeadImg(userDTO.getHeadImg());
        virtualUser.setNickname(userDTO.getNickName());
        virtualUser.setSex(userDTO.getSex());
        return virtualUser;
    }

    private VirtualUserOverviewDTO convert(VirtualUserDTO virtualUserDTO) {
        VirtualUserOverviewDTO virtualUserOverviewDTO = new VirtualUserOverviewDTO();
        virtualUserOverviewDTO.setId(virtualUserDTO.getUserId());
        virtualUserOverviewDTO.setNickname(virtualUserDTO.getNickName());
        virtualUserOverviewDTO.setHeadImg(virtualUserDTO.getHeadImg());
        virtualUserOverviewDTO.setUserInfo(virtualUserDTO.getTag());
        return virtualUserOverviewDTO;
    }

    public VirtualUserOverviewDTO getByIdCacheFirst(Long virtualId) {
        if (Objects.isNull(this.cache)) {
            this.cache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(1L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<Long, VirtualUserOverviewDTO>(){

                public VirtualUserOverviewDTO load(Long key) throws Exception {
                    VirtualUserDTO virtualUserDTO = VirtualUserIntegrationService.this.virtualUserFacadeService.get(key);
                    if (null == virtualUserDTO) {
                        return new VirtualUserOverviewDTO();
                    }
                    return VirtualUserIntegrationService.this.convert(virtualUserDTO);
                }
            });
        }
        return (VirtualUserOverviewDTO)this.cache.getUnchecked((Object)virtualId);
    }
}

