package com.bxm.localnews.integration;

import com.bxm.egg.facade.service.LocationFacadeService;
import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.user.facade.service.*;
import com.bxm.foundation.base.facade.service.DomainFacadeService;
import com.bxm.foundation.base.facade.service.SensitiveWordFacadeService;
import com.bxm.foundation.base.facade.service.ShortUrlFacadeService;
import com.bxm.foundation.user.facade.VirtualUserFacadeService;
import com.bxm.thirdparty.payment.facade.PaymentFacadeService;
import lombok.Getter;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

/**
 * 统一声明内部服务的调用
 *
 * @author liujia
 * @date 9/15/21 12:48 PM
 **/
@Getter
@Service
public class InnerServiceIntegrationService {

    @DubboReference(protocol = "dubbo",
            cluster = "failover",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private MessageFacadeService messageFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failover",
            version = "1.0.0",
            check = false,
            cache = "lru",
            lazy = true
    )
    private DomainFacadeService domainFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failover",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private ShortUrlFacadeService shortUrlFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failover",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private VirtualUserFacadeService virtualUserFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failover",
            version = "1.0.0",
            mock = "com.bxm.localnews.integration.mock.SensitiveWordFacadeServiceMock",
            check = false,
            lazy = true
    )
    private SensitiveWordFacadeService sensitiveWordFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failover",
            version = "1.0.0",
            mock = "com.bxm.egg.facade.mock.LocationFacadeServiceMock",
            check = false,
            lazy = true
    )
    private LocationFacadeService locationFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failover",
            version = "1.0.0",
            mock = "com.bxm.egg.user.facade.mock.UserWarmFacadeServiceMock",
            check = false,
            lazy = true
    )
    private UserWarmFacadeService userWarmFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failover",
            version = "1.0.0",
            mock = "com.bxm.egg.user.facade.mock.UserInfoFacadeServiceMock",
            check = false,
            lazy = true
    )
    private UserInfoFacadeService userInfoFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failover",
            version = "1.0.0",
            mock = "com.bxm.egg.user.facade.mock.UserEggAccountFacadeServiceMock",
            check = false,
            lazy = true
    )
    private UserEggAccountFacadeService userEggAccountFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failover",
            version = "1.0.0",
            mock = "com.bxm.egg.user.facade.mock.UserStatisticsFacadeServiceMock",
            check = false,
            lazy = true
    )
    private UserStatisticsFacadeService userStatisticsFacadeService;

    @DubboReference(protocol = "dubbo",
            cluster = "failover",
            version = "1.0.0",
            check = false,
            mock = "com.bxm.localnews.integration.mock.UserAuthFacadeServiceMock",
            lazy = true
    )
    private UserAuthFacadeService userAuthFacadeService;

    /**
     * 支付服务的处理时间较长，超时时间需要设置的长一点
     */
    @DubboReference(protocol = "dubbo",
            cluster = "failover",
            version = "1.0.0",
            mock = "com.bxm.thirdparty.payment.mock.PaymentFacadeServiceMock",
            check = false,
            timeout = 6000,
            lazy = true
    )
    private PaymentFacadeService paymentFacadeService;
}
